package com.junmp.jyzb.api.bean.req;

import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 装备批量信息修改的请求实体类
 */
@Data
public class BatchEditingInvsReq {
    /**
     * 组织机构id
     */
    private Long orgId;

    /**
     *类型id
     */
    private String typeId;

    /**
     *号型id
     */
    private String sizeId;
    private String typeName;
    private String sizeName;

    /**
     *仓库id
     */
    private String locationId;

    private String locationName;

    /**
     *装备id
     */
    private List<InventoryReq> inventoryList;

    /**
     *生产日期
     */
    private Date productionDate;

    /**
     *质保期
     */
    private Integer warrantyPeriod;

    /**
     *维保期
     */
    private Integer maintenancePeriod;

    /**
     *货架id
     */
    private String shelfId;

    /**
     * 排
     */
    private Integer shelfRanges;

    /**
     * 列
     */
    private Integer shelfColumns;

    /**
     * 行
     */
    private Integer shelfRows;

    /**
     * 单价(修改后单价)
     */
    private BigDecimal price;

    /**
     * 原来价格
     */
    private BigDecimal originalPrice;

}
