package com.junmp.jyzb.api.bean.query.hardWareReq;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;

@Data
public class HardWarePoliceReq {
    //警员id(获取绑定装备列表接口使用)
    private String id;

    //修改单警柜和警员信息接口使用
    @NotEmpty(message = "警员id不能为空",groups = {ValidationApi.detail.class, ValidationApi.list.class,ValidationApi.delete.class})
    private String userId;
    @NotEmpty(message = "修改类型不能为空",groups = {ValidationApi.detail.class})
    private String type;
    private String typeValue1;
    private String typeValue2;


    //版本编码（获取软件版本更新接口使用）
    @NotEmpty(message = "appCode不能为空",groups = {ValidationApi.edit.class})
    private String appCode;


    @NotEmpty(message = "cabinetRealID不能为空",groups = {ValidationApi.delete.class})
    @JsonProperty("cabinetRealID")
    private String cabinetRealID;

    @NotNull(message = "cabinetChildID不能为空",groups = {ValidationApi.delete.class})
    @JsonProperty("cabinetChildID")
    private Integer cabinetChildID;

    private String password;
    private String finger1Features;
    private String finger2Features;
    private String faceFeatures;

}
