package com.junmp.jyzb.api.bean.query.hardWareReq;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.common.bean.request.ValidationApi;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.Size;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class HardWareCabReq extends BaseRequest {
    //组织机构id（guid）
//    @NotEmpty(message = "组织机构id不能为空",groups = {detail.class})
    private String organizationId;

    //单警柜编号-不是id
    @NotEmpty(message = "单警柜编号不能为空",groups = {detail.class})
    private String cabinetNum;

    //（获取单警柜警员信息接口使用）类型：all全部,single单警柜下全部警员,allBind单警柜对应组织机构下的所有人,allUser单警柜的组织机构下全部已绑定柜子的警员
    //（库存接口使用）类型：0:typeName,1:typeName,sizeName,boxNo,2:typeName,supplierName.boxNo,其他：boxNo
    //(修改单警柜整柜模式接口使用)：0单警柜--3.0为1，1值班柜--3.0为3，2公共柜--3.0为2
    @NotEmpty(message = "类型不能为空",groups = {detail.class,updateStatus.class})
    private String type;

    @NotEmpty(message = "单警柜号必传",groups = {updateStatus.class})
    private String currentCabinetNum;

    //epc列表
    @Size(message = "RFID列表不能为空", min = 1,groups = {export.class})
    @JsonProperty("RFIDList")
    private List<String> RFIDList;

    //主柜号（公共柜箱门装备绑定）
    @NotEmpty(message = "单警柜主柜号必传",groups = {export.class})
    @JsonProperty("cabinetID")
    private String cabinetID;
    //箱号（公共柜箱门装备绑定）
    @NotEmpty(message = "箱号必传",groups = {export.class})
    @JsonProperty("cabinetChildID")
    private String cabinetChildID;

    //equipmentId装备编号（获取类型接口使用）
    private String equipmentId;

    //装备名称
    private String name;

    //装备号型id（获取号型接口使用）
    private String detailId;

    private String childNum;

    //上传操作日志使用
     @NotEmpty(message = "单警柜编号不能为空",groups = {edit.class})
    private String cabinetMainNo;
    private List<WorkLogReq> logList;

    @Data
    public static class WorkLogReq{
        private String id;

        private String date;

        private String type;

        private String name;

        private String logInfo;

        private String photo;

        private String isDeal;

        private String deviceNo;
    }

    //单警柜号（获取公共柜下绑定的警员信息接口使用、公共柜用户箱门绑定使用）
    @NotEmpty(message = "单警柜号必传",groups = {ValidationApi.list.class})
    @JsonProperty("cabinetRealID")
    private String cabinetRealID;

    private String userId;
    private String boxNo;
    private List<BoxUserReq> list;

    @Data
    public static class BoxUserReq{
        private String boxNo;
        private String userName;
        private String userId;
    }

}
