package com.junmp.jyzb.api.bean.query;

import com.baomidou.mybatisplus.annotation.TableField;
import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.v2.common.bean.request.BaseRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NonNull;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class LogSummaryReq extends BaseRequest {
    /**
     * 出入库汇总ID
     */
    private Long id;

    /**
     * 组织机构ID
     */
//    @NotNull(message = "组织机构id不能为空",groups = {page.class})
    private Long orgId;

    /**
     * 组织机构名称
     */
    private String orgName;

    private String orderCode;

    /**
     * 单据id
     */
    @NotBlank(message = "单据id不能为空",groups = {detail.class})
    private String orderMainId;

    /**
     * 存储ID
     */
    private String locationId;


    /**
     * 存储名称：XX仓库，XX单警柜
     */
    private String locationName;

    /**
     * 0仓库，1单警柜
     */
    @NotBlank(message = "位置不能为空",groups = {page.class})
    private String locationType;

    /**
     * 设备标识
     */
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道/5打印机
     */
    private Integer deviceType;

    /**
     * 操作时间
     */
    private Date useTime;

    /**
     * 业务类型
     */
    private String bussinessType;
    /**
     * 操作人员姓名
     */
    private String userName;

    /**
     * 出入库类型
     */
    private String outInState;

    private Integer number;

    /**
     * 照片信息(3.0)
     */
    private String picture;

    /**
     * 照片信息(2.0)
     */
    private String photo;

    /**
     * 装备记录集合，警棍、盾牌
     */
    private String equipmentList;

    /**
     * 创建时间
     */
    private Date createTime;

    /**
     * 更新时间
     */
    private Date updateTime;

    /**
     * 更新人员
     */
    private String updateUser;

    /**
     * 创建人员
     */
    private String createUser;
    /**
     * 装备详细信息
     */
    private List<LogDetailReq> logList;
    /**
     * 是操作日志
     */
    private List<OrderLogReq> orderLogList;

    private String typeId;
    private String sizeId;
    private BigDecimal price;
    private Integer property;
    private String epc;

    private String column;
    private String order;

    private String startTime;
    private String endTime;

    private String typeName;
    private String sizeName;

    //查看本级还是本机极其下级，0为查看本级，1为查看本级及下级
    @NotBlank(message = "查看范围不可为空，0查看本级，1查看本级及下级")
    private Integer isAllOrgVisible;
}

