package com.junmp.jyzb.api.bean.query;

import com.junmp.v2.common.bean.request.BaseRequest;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.List;

@Data
@EqualsAndHashCode(callSuper = true)
public class CabinetReq extends BaseRequest {
    /**
     * 单警柜ID
     */

    @ApiModelProperty(value = "单警柜ID")
    private String id;

    @ApiModelProperty(value = "智能柜本地主键编号")
    private String boxLocalId;

    /**
     * 单警柜编号
     */
    @NotBlank(message = "单警柜编号主键不能为空", groups = {edit.class, delete.class, detail.class})
    @ApiModelProperty(value = "单警柜编号")
    private String devSn;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱数")
    private Integer num;

    /**
     * 类型
     */
    @ApiModelProperty(value = "类型")
    private String containType;
    /**
     * 单警柜名称
     */
    @ApiModelProperty(value = "单警柜名称")
    private String name;

    /**
     * 组织机构号
     */
    @ApiModelProperty(value = "组织机构号")
    private Long orgId;

    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String location;

    /**
     * 组织机构编号
     */
    private String orgCode ;

    /**
     * 单警柜当前状态，0正常，1异常
     */
    @ApiModelProperty(value = "单警柜当前状态，0正常，1异常")
    private Integer state;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 更新人员
     */
    @ApiModelProperty(value = "更新人员")
    private String updateUser;

    /**
     * 是否包含本级及下级，true为包含，false为不包含，只显示本级
     */
    @ApiModelProperty(value = "本机及下级")
    private String includeLowerLevel;

    /**
     * 版本号
     */
    private String version;

    /**
     * 是否升级（0不升级，1升级）
     */
    private Integer isUpgrade;

    /**
     * 排序字段
     */
    private String sort;

    private static final long serialVersionUID = 1L;
}
