package com.junmp.jyzb.api.bean.dto;

import com.junmp.jyzb.api.bean.query.inAndOutRecordReq.DetailJsonReq;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

@Data
public class OrderDetailDto implements Serializable {

    private Long id;

    private String orderId;

    private String typeId;

    private String typeName;

    private String sizeId;

    private String sizeName;

    private String supplierId;

    private String supplierName;

    private String warehouseId;

    private String warehouseName;

    /**
     * 计划数量
     */
    private Integer planNum;
    /**
     * 实际数量
     */
    private Integer actualNum;
    //记账数量
    private Integer modifyQuantity;

    private String price;

    //预计金额
    private BigDecimal totalPrice;

    //实际金额
    private BigDecimal actualTotalPrice;

    private String detailJson;
    /**
     * 在库数
     */
    private Integer stockNumber;

    /**
     * 生产日期
     */
    private Date productionDate;

    /**
     * 质保期
     */
    private Integer warrantyPeriod;

    /**
     * 维保期
     */
    private Integer maintenancePeriod;

    private String remark;

    private List<DetailJsonReq> childJson;

    //Epc类型（0固定资产1库存物资非固定资产）
    private Integer property;


}
