package com.junmp.jyzb.api.bean.dto;

import lombok.Data;

import java.util.List;

@Data
public class MQDto {
    /**
     * 本地主机定义类型
     */
    private String api;

    /**
     * 订单状态
     */
    private String orderState;

    /**
     * 推送消息类型
     *
     * @see com.junmp.jyzb.api.enums.PushMsgTypeEnum
     */
    private Integer type;

    /**
     * 装备主键编号集合
     */
    private List<String> idList;

    /**
     * 消息内容
     */
    private String message;

    /**
     * 订单主键编号
     */
    private String orderId;

    /**
     * 仓库主键编号
     */
    private String warehouseId;

    /**
     * 仓库状态
     */
    private Integer warehouseState;
}
