package com.junmp.jyzb.api.bean.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

@Data
public class CabinetDto implements Serializable{
    /**
     * 单警柜ID
     */
    @ApiModelProperty(value = "单警柜ID")
    private String id;

    /**
     * 单警柜编号
     */
    @ApiModelProperty(value = "单警柜编号")
    private String devSn;

    /**
     * 箱数
     */
    @ApiModelProperty(value = "箱门数量")
    private Integer num;

    /**
     * 单警柜名称
     */
    @ApiModelProperty(value = "单警柜名称")
    private String name;

    /**
     * 组织机构号
     */
    @ApiModelProperty(value = "组织机构号")
    private Long orgId;
    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String orgName;
    /**
     * 位置信息
     */
    @ApiModelProperty(value = "位置信息")
    private String location;
    /**
     * 警柜配置
     */
    @ApiModelProperty(value = "警柜配置")
    private String config;

    /**
     * 单警柜号
     */
    @ApiModelProperty(value = "单警柜号")
    private String serverNum;

    private Integer state;
    /**
     * 在线状态
     */
    @ApiModelProperty(value = "在线状态")
    private Integer onlineState;

    /**
     * 版本号
     */
    private String version;

    /**
     * 是否升级（0不升级，1升级）
     */
    private Integer isUpgrade;

    private Integer departmentId;

    private List<CabinetBoxDto> cabinetBoxList;

}