package com.junmp.jyzb.api.bean.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class CabinetBoxDto implements Serializable {
    /**
     * 主键ID
     */
    @ApiModelProperty(value = "主键ID")
    private String id;

    @ApiModelProperty(value = "智能柜本地设主键编号")
    private String boxLocalId;

    /**
     * 箱号
     */
    @ApiModelProperty(value = "箱门号")
    private Integer boxNo;

    /**
     * 异常状态:1正常/0异常
     */
    @ApiModelProperty(value = "异常状态:1正常/0异常")
    private Integer state;

    /**
     * 异常原因
     */
    @ApiModelProperty(value = "异常原因")
    private String errorMsg;


    /**
     * 箱门绑定警员id
     */
    private String policeId;
    /**
     * 装备配置
     */
    private String equipmentConfig;

    /**
     * 箱门绑定警员名称
     */
    private String policeName;

    /**
     * 箱门类型：1单警柜，2公共柜
     */
    @ApiModelProperty(value = "箱门类型：1单警柜，2公共柜")
    private Integer containType;

    /**
     * 功率
     */
    private String power;

    private String boxName;

    /**
     * 主柜ID
     */
    @ApiModelProperty(value = "主柜ID")
    private String cabinetId;

    /**
     * 使用日志存储位置信息
     */
    @ApiModelProperty(value = "使用日志存储位置信息")
    private String logMap;

    private Date createTime;

    private Date updateTime;

}
