package com.junmp.jyzb.api.annotation;

import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import cn.hutool.core.util.StrUtil;
//import com.junmp.v2.common.enums.ResBizTypeEnum;
import org.springframework.core.annotation.AliasFor;
import java.lang.annotation.*;
@Target(ElementType.METHOD)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@RequestMapping(method = RequestMethod.POST)

public @interface PostRequest {



    /**
     * 资源名称(必填项)
     */
    String name() default "";



    /**
     * 当前接口是否需要登录(true-需要登录,false-不需要登录)
     */
    boolean requiredLogin() default false;

    /**
     * 当前接口是否需要鉴权(true-需要鉴权,false-不需要鉴权)
     */
    boolean requiredPermission() default false;

    /**
     * 数据是否要求签名 (true-需要,false-不需要)
     */
    boolean requiredSignature() default true;

    /**
     * 是否需要请求验证请求时效性（true-需要,false-不需要）
     */
    boolean requiredEffective() default false;

    /**
     * 请求有效时间
     */
    long effectiveTime() default 30000;



    /**
     * 当前接口需要的权限标识（菜单的编码或者菜单功能的编码，从sys_menu表或者sys_menu_options表查询）
     * <p>
     * 如果requiredPermission = true，则需要填写此编码
     */
    String requirePermissionCode() default StrUtil.EMPTY;

    /**
     * 是否需要请求解密，响应加密 (true-需要,false-不需要)
     */
    boolean requiredEncryption() default false;



    /**
     * 请求路径(同RequestMapping)
     */
    @AliasFor(annotation = RequestMapping.class)
    String[] path() default {};

    /**
     * 请求的http方法(同RequestMapping)
     */
    @AliasFor(annotation = RequestMapping.class)
    RequestMethod[] method() default RequestMethod.POST;

    /**
     * 同RequestMapping
     */
    @AliasFor(annotation = RequestMapping.class)
    String[] produces() default {};

}
