﻿using System;
using System.Collections.Generic;
using System.IO.Ports;
using System.Linq;
using System.Threading;

namespace JmpDehumidifierLib
{
    internal delegate void MessageReceivedDeleg(byte[] msg);

    internal class Serial : IDevice
    {
        private SerialPort port1;
        private readonly string SerialName = "COM1";
        private Queue<byte[]> queMsg = new Queue<byte[]>();

        public Serial(string name)
        {
            SerialName = name;
        }

        /// <summary>
        /// 关闭
        /// </summary>
        /// <param name="comPort"></param>
        /// <returns></returns>
        public bool Close()
        {
            try
            {
                port1.DataReceived -= new System.IO.Ports.SerialDataReceivedEventHandler(this.OnDataReceived);
                if (port1.IsOpen == true && port1.PortName == SerialName)
                {
                    port1.Close();
                    port1.Dispose();
                    return true;
                }
                else
                {
                    port1.Dispose();
                    return false;
                }
            }
            catch (System.Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return false;
            }
        }

        /// <summary>
        /// 打开
        /// </summary>
        /// <param name="comPort"></param>
        /// <returns></returns>
        public bool Open()
        {
            try
            {
                // 打开前已存在，则关闭
                if (port1 != null)
                {
                    port1.Dispose();
                    Thread.Sleep(50);
                }

                // 判断串口是否存在, 如果不存在，则打开失败
                if (!SerialPort.GetPortNames().Contains(SerialName))
                {
                    Console.WriteLine("串口不存在!");
                    return false;
                }

                port1 = new SerialPort(SerialName, 9600, Parity.None, 8, StopBits.One);
                port1.DataReceived += new System.IO.Ports.SerialDataReceivedEventHandler(this.OnDataReceived);
                port1.Open();
                if (port1.IsOpen == true)
                {
                    port1.DiscardInBuffer();
                    port1.DiscardOutBuffer();

                    Thread thr = new Thread(DealMsgs)
                    {
                        IsBackground = true
                    };
                    thr.Start();
                    return true;
                }
                else
                {
                    port1.Dispose();
                    return false;
                }
            }
            catch (System.Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return false;
            }
        }

        /// <summary>
        /// Send
        /// </summary>
        /// <param name="command"></param>
        /// <param name="len"></param>
        /// <returns></returns>
        public bool Send(byte[] msg)
        {
            try
            {
                if (port1.IsOpen)
                {
                    if (msg != null && msg.Length >= 8)
                    {
                        // 发送
                        port1.Write(msg, 0, msg.Length);
                        return true;
                    }

                    Console.WriteLine("发送失败!");
                    return false;
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
            return false;
        }

        private readonly object _lock_ = new object();
        /// <summary>
        /// Recerive
        /// </summary>
        /// <param name="sender"></param>
        /// <param name="e"></param>
        private void OnDataReceived(object sender, SerialDataReceivedEventArgs e)
        {
            try
            {
                lock (_lock_)
                {
                    var len = port1.BytesToRead;
                    byte[] buf = new byte[len];
                    port1.Read(buf, 0, len);
                    if (len > 0)
                    {
                        lock (queMsg)
                        {
                            queMsg.Enqueue(buf);
                        }
                    }
                }
            }
            catch (System.Exception ex)
            {
                Console.WriteLine(ex.ToString());
            }
        }
        
        private void DealMsgs()
        {
            while(port1.IsOpen)
            {
                while(queMsg.Count > 0)
                {
                    byte[] msg = null;
                    lock(queMsg)
                    {
                        msg = queMsg.Dequeue();
                    }
                    OnMsgRcv(msg);
                }
                Thread.Sleep(10);
            }
        }

        public event MessageReceivedDeleg MsgRcvEvent;

        public void OnMsgRcv(byte[] msg)
        {
            MsgRcvEvent?.Invoke(msg);
        }
    }
}
