﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Sockets;
using System.Text;
using System.Threading;

namespace JmpDehumidifierLib
{
    internal class JpSocket : IDevice
    {
        private readonly string SrvIp = "127.0.0.1";
        private readonly int SrvPort = 7890;
        private Thread threadClient = null; // 创建用于接收服务端消息的 线程；
        private Socket sockClient = null;
        private bool sockClientEnable = false;
        private Queue<byte[]> queMsg = new Queue<byte[]>();

        public JpSocket(string ip, int port)
        {
            SrvIp = ip;
            SrvPort = port;
        }

        /// <summary>
        /// 关闭
        /// </summary>
        /// <param name="comPort"></param>
        /// <returns></returns>
        public bool Close()
        {
            try
            {
                // 停止接收线程
                sockClientEnable = false;
                // 关闭SOCKET
                if (sockClient != null && sockClient.Connected)
                {
                    sockClient.Close();
                }
                return true;
            }
            catch (System.Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return false;
            }
        }

        /// <summary>
        /// 打开
        /// </summary>
        /// <param name="comPort"></param>
        /// <returns></returns>
        public bool Open()
        {
            try
            {
                IPAddress ip = IPAddress.Parse(SrvIp);
                IPEndPoint endPoint = new IPEndPoint(ip, SrvPort);
                sockClient = new Socket(AddressFamily.InterNetwork, SocketType.Stream, ProtocolType.Tcp);
                try
                {
                    sockClient.Connect(endPoint);
                }
                catch (SocketException se)
                {
                    Console.WriteLine(se.Message);
                    return false;
                }

                if (sockClientEnable == false)
                {
                    sockClientEnable = true;
                    threadClient = new Thread(RecMsg)
                    {
                        IsBackground = true
                    };
                    threadClient.Start();
                    Thread thr = new Thread(DealMsgs)
                    {
                        IsBackground = true
                    };
                    thr.Start();
                }
                return true;
            }
            catch (System.Exception ex)
            {
                Console.WriteLine(ex.Message);
                return false;
            }
        }

        void RecMsg()
        {
            while (sockClientEnable)
            {
                // 定义一个2M的缓存区；
                byte[] arrMsgRec = new byte[4096];
                // 将接受到的数据存入到输入  arrMsgRec中；
                int len = -1;
                try
                {
                    len = sockClient.Receive(arrMsgRec); // 接收数据，并返回数据的长度；

                    if (len > 0)
                    {
                        byte[] buf = new byte[len];
                        Array.Copy(arrMsgRec, buf, len);
                        lock (queMsg)
                        {
                            queMsg.Enqueue(buf);
                        }
                    }
                }
                catch (SocketException se)
                {
                    Console.WriteLine(se.Message);
                    return;
                }
                catch (Exception e)
                {
                    Console.WriteLine(e.Message);
                    return;
                }
            }
        }

        private void DealMsgs()
        {
            while (sockClientEnable)
            {
                while (queMsg.Count > 0)
                {
                    byte[] msg = null;
                    lock (queMsg)
                    {
                        msg = queMsg.Dequeue();
                    }
                    OnMsgRcv(msg);
                }
                Thread.Sleep(10);
            }
        }

        /// <summary>
        /// Send
        /// </summary>
        /// <param name="command"></param>
        /// <param name="len"></param>
        /// <returns></returns>
        public bool Send(byte[] msg)
        {
            try
            {
                if (sockClient != null && sockClient.Connected)
                {
                    // 组包
                    if (msg != null && msg.Length >= 8)
                    {
                        // 发送
                        sockClient.Send(msg, 0, msg.Length, SocketFlags.None);
                        return true;
                    }

                    Console.WriteLine("发送失败!");
                    return false;
                }

                Console.WriteLine("网络未打开!");
                return false;
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex.ToString());
                return false;
            }
        }

        public event MessageReceivedDeleg MsgRcvEvent;
        public void OnMsgRcv(byte[] msg)
        {
            MsgRcvEvent?.Invoke(msg);
        }
    }
}
