﻿namespace JmpDehumidifierLib
{
    internal class Controller
    {
        internal IDevice device;
        internal Controller(IDevice dev)
        {
            this.device = dev;
            device.MsgRcvEvent +=new MessageReceivedDeleg(Device_MsgRcvEvent);
        }

        internal bool Open()
        {
            return device.Open();
        }

        internal bool Close()
        {
            return device.Close();
        }

        internal bool Send(byte[] command)
        {
            return device.Send(command);
        }

        /// <summary>
        /// 接收并发送解析后的消息
        /// </summary>
        /// <param name="msg"></param>
        /// <param name="len"></param>
        internal void Device_MsgRcvEvent(byte[] msg)
        {
            OnMsgRcv(msg);
        }
        
        internal event MessageReceivedDeleg MsgRcvEvent;

        internal void OnMsgRcv(byte[] msg)
        {
            MsgRcvEvent?.Invoke(msg);
        }
    }
}
