﻿using JmpDehumidifierLib;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace JmpDehumidifier
{
    public partial class Demo : Form
    {
        private Dehumidifier dev = null;
        public Demo()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            dev = new Dehumidifier(Properties.Settings.Default.IP,Properties.Settings.Default.port);
            if(dev.Open())
            {
                dev.OnStatusChanged += new Dehumidifier.StatusChanged(OnStatusChanged);
            }
        }

        private void btn_SetHumid_Click(object sender, EventArgs e)
        {
            if (dev.SetHumid(Convert.ToByte(tb_SetHumid.Text)))
            {
                MessageBox.Show("成功！");
            }
            else
            {
                MessageBox.Show("失败！");
            }
        }

        private void btn_OpenClose_Click(object sender, EventArgs e)
        {
            if (dev.OpenMachine(btn_OpenClose.Text == "Open"))
            {
                MessageBox.Show("成功！");
            }
            else
            {
                MessageBox.Show("失败！");
            }
            if(btn_OpenClose.Text == "Open")
            {
                btn_OpenClose.Text = "Close";
            }
            else
            {
                btn_OpenClose.Text = "Open";
            }
        }

        public delegate void StatusChangedDeleg(MachineStatus args);
        private void OnStatusChanged(MachineStatus args)
        {
            if (this.InvokeRequired)
            {
                this.BeginInvoke(new StatusChangedDeleg(OnStatusChanged), new object[] { args });
                return;
            }
            tb_Temp.Text = args.Temp.ToString();
            tb_Humid.Text = args.Humid.ToString();
            tb_ErrorCode.Text = args.ErrorCode.ToString();
            tb_SetHumid.Text = args.SetHumid.ToString();
            if(args.IsWorking)
            {
                btn_OpenClose.Text = "Close";
            }
            else
            {
                btn_OpenClose.Text = "Open";
            }
        }
    }
}
