/**
 * 邮箱
 * @param {*} s
 */
 export function isEmail (str: string) {
  return /^([a-zA-Z0-9._-])+@([a-zA-Z0-9_-])+((.[a-zA-Z0-9_-]{2,3}){1,2})$/.test(str)
}

/**
 * 手机号码
 * @param {*} s
 */
export function isMobile (str: string) {
  return /^1[0-9]{10}$/.test(str)
}

/**
 * 电话号码
 * @param {*} s
 */
export function isPhone (str: string) {
  return /^([0-9]{3,4}-)?[0-9]{7,8}$/.test(str)
}

/**
 * URL地址
 * @param {*} s
 */
export function isURL (str: string) {
  return /^http[s]?:\/\/.*/.test(str)
}
