import Vue from 'vue'
import Axios, { Method, ResponseType, AxiosResponse } from 'axios'

import { message } from 'ant-design-vue';
import 'ant-design-vue/es/message/style/css'; //vite只能用 ant-design-vue/es 而非 ant-design-vue/lib

interface axiosData {
  url: string
  method: Method
  headers?: any
  json: boolean
  contentType?: string
  data?: any
  params?: any
  responseType?: ResponseType
}

let apiBaseUrl = (window as any)._CONFIG['domianURL'] || '/'
const axios = Axios.create({
  baseURL: apiBaseUrl,
  timeout: 3000
})

// 允许携带cookie
axios.defaults.withCredentials = true

// 默认使用 application/json 形式
axios.defaults.headers.post['Content-Type'] = 'application/json'

// 请求拦截器
axios.interceptors.request.use(
  (config) => {
    const token = Vue.ls.get(ACCESS_TOKEN)
    if (token) {
        config.headers[ 'X-Access-Token' ] = token // 让每个请求携带自定义 token 请根据实际情况自行修改
    }
    return config;
  },
  (err) => Promise.reject(err)
)
  
// 响应拦截器
axios.interceptors.response.use(
  (res) => res,
  (err) => {
    if (err.response && err.response.data) {
      const code = err.response.status
      const msg = err.response.data.message
      message.error(`Code: ${code}, Message: ${msg}`)
    } else {
        message.error(`${err}`)
    }
    return Promise.reject(err)
  }
)

export default function request(arr: axiosData) {
  return new Promise<any>((resolve, reject) => {
    axios({
      url: arr.url,
      method: arr.method || 'POST',
      headers: {
        'content-type': arr.contentType ? arr.contentType : arr.json ? 'application/json; charset=UTF-8' : 'application/x-www-form-urlencoded; charset=UTF-8'
      },
      params: arr.params || '',
      data: arr.data || '',
      responseType: arr.responseType || 'json'
    })
      .then((response: AxiosResponse<any>) => {
        if (response.data.code == 99200) {
          message.error(response.data)
          reject(response.data)
          return
        }
        resolve(response.data)
      })
        .catch((err) => {
          message.error(err.message)
          reject(err)
        })
  })
}