import { InjectionKey } from 'vue'
import { createStore, useStore as baseUseStore, Store } from 'vuex'
import RootStateTypes, { AllStateTypes } from './types';

const defaultState = {
  count: 0
};
// 新建store 实例
export const store = createStore({
  state() {
    return defaultState;
  },
  mutations: {
    increment(state: typeof defaultState) {
      // eslint-disable-next-line no-plusplus
      state.count++;
    },
  },
  actions: {
    increment(context) {
      context.commit('increment');
    },
  },
  getters: {
    count(state: typeof defaultState) {
      return state.count;
    },
  },
  modules: {
      
  }
})
// 定义 injection key
export const key: InjectionKey<Store<RootStateTypes>> = Symbol('vue3-store')

// 定义自己的 `useStore` 组合式函数
export function useStore<T = AllStateTypes> () {
    return baseUseStore<T>(key)
}