import {
  createRouter, createWebHashHistory, RouteRecordRaw,
} from 'vue-router';

export const constantRouterMap: Array<RouteRecordRaw> = [
  {
    path: '/',
    name: 'helloWorld',
    component: () => import('@/components/HelloWorld.vue'),
  }
]

const router = createRouter({
  history: createWebHashHistory(), // hash模式：createWebHashHistory，history模式：createWebHistory
  scrollBehavior: () => ({ // 切换路由, 始终滚动到顶部
    top: 0
  }),
  routes: constantRouterMap
});

export default router;
