import axios from 'axios'
import { VueAxios } from './axios'


let apiBaseUrl = window._CONFIG['publicURL']
// 创建 axios 实例
const request = axios.create({
  // API 请求的默认前缀
  baseURL: apiBaseUrl,
  timeout: 3000 // 请求超时时间
})


axios.interceptors.request.use((request) => {
  return request
})

request.interceptors.response.use((response) => {
  return response.data
})

const installer = {
  vm: {},
  install (Vue) {
    Vue.use(VueAxios, request)
  }
}

export default request

export {
  installer as VueAxios,
  request as axios
}
