package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.NormalInOutDto;
import com.junmp.jyzb.api.bean.query.InAndOutRecordReq.*;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.mapper.InventorySummaryMapper;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.mapper.LogSummaryMapper;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.util.BeanPlusUtil;
import com.junmp.v2.db.api.factory.PageFactory;
import com.junmp.v2.db.api.factory.PageResultFactory;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_summary】的数据库操作Service实现
* @createDate 2023-10-13 08:29:36
*/
@Service
public class LogSummaryServiceImpl extends ServiceImpl<LogSummaryMapper, LogSummary>
    implements LogSummaryService{

    @Resource
    private LogSummaryService logSummaryService;

    @Resource
    private InventoryService inventoryService;

    @Resource
    private OrderMainService orderMainService;

    @Resource
    private OrderDetailService orderDetailService;

    @Resource
    private LogDetailService logDetailService;

    @Resource
    private InventorySummaryService inventorySummaryService;

    @Resource
    private InventorySummaryMapper inventorySummaryMapper;

    //根据条件查询出入库记录
    @Override
    public PageResult<LogSummary> ShowInOutRecordsByItems(LogSummaryReq req) {
        //(如果传其他不是数据库字段参数或者排序规则不是deac或者asc可能会出现错误)
        if (ObjectUtil.isNotNull(req.getColumn()) && !req.getColumn().trim().isEmpty() &&
                (req.getOrder().equalsIgnoreCase("asc")|| req.getOrder().equalsIgnoreCase("desc")) &&
                ObjectUtil.isNotNull(req.getOrder()) && !req.getOrder().trim().isEmpty()) {
            //修改字段，和数据库字段进行统一
            req.setColumn(req.getColumn().replaceAll("[A-Z]", "_$0").toLowerCase());
            req.setOrder(req.getOrder().toLowerCase());
        }
        LambdaQueryWrapper<LogSummary> eq = new LambdaQueryWrapper<LogSummary>()
                .eq(LogSummary::getOrgId,req.getOrgId())
                .eq(LogSummary::getLocationType,req.getLocationType())
                .eq(ObjectUtil.isNotNull(req.getBussinessType()) && !req.getBussinessType().trim().isEmpty(),LogSummary::getBussinessType,req.getBussinessType())
                .eq(ObjectUtil.isNotNull(req.getOutInState()) && !req.getOutInState().trim().isEmpty(),LogSummary::getOutInState,req.getOutInState())
                .eq(ObjectUtil.isNotNull(req.getLocationId()),LogSummary::getLocationId,req.getLocationId())
                .eq(ObjectUtil.isNotNull(req.getUserName()),LogSummary::getUserName,req.getUserName())
                .ge(ObjectUtil.isNotNull(req.getStartTime()),LogSummary::getUseTime,req.getStartTime())
                .le(ObjectUtil.isNotNull(req.getEndTime()),LogSummary::getUseTime,req.getEndTime())
                .like(ObjectUtil.isNotNull(req.getEquipmentList()),LogSummary::getEquipmentList,req.getEquipmentList())
                .last("order by " + req.getColumn() + " " + req.getOrder());
        Page<LogSummary> page = logSummaryService.page(PageFactory.getDefaultPage(req.getPageNo(), req.getPageSize()), eq);
        return PageResultFactory.createPageResult(page);
    }

    //本地主机返回出入库结果
    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean processInventoryRecords(OutInLogsReq req) {
        //1.判断业务类型,如果是采购，更新装备库存表
        boolean a=false;
        if (req.getBussinessType().equals("purchase")){
            List<PurchaseEqsReq> purchaseList = req.getOrderMain().getPurchaseList();
            List<Inventory> collect = purchaseList.stream().map(purchaseEqsReq -> {
                Inventory inventory = new Inventory();
                BeanPlusUtil.copyProperties(purchaseEqsReq, inventory);
                return inventory;
            }).collect(Collectors.toList());
            a=inventoryService.saveBatch(collect);
        }
        //2.如果有单据，更新单据
        boolean b=false;
        boolean c=false;
        if (ObjectUtil.isNotNull(req.getOrderMain())){
            OrderReq orderMain = req.getOrderMain();
            List<DetailOrderReq> orderDetailList = orderMain.getOrderDetail();
            OrderMain one = orderMainService.getOne(new LambdaQueryWrapper<OrderMain>()
                    .eq(OrderMain::getId, orderMain.getId()));
            one.setPrice(orderMain.getPrice());
            one.setActualQuantity(orderMain.getActualQuantity());
            one.setOrderState(one.getOrderState());
            b=orderMainService.updateById(one);
            List<OrderDetail> collect = orderDetailList.stream().map(detailOrderReq -> {
                OrderDetail orderDetail = new OrderDetail();
                BeanPlusUtil.copyProperties(detailOrderReq, orderDetail);
                //记账数量默认时识别数量
                orderDetail.setModifyQuantity(detailOrderReq.getActualNum());
                return orderDetail;
            }).collect(Collectors.toList());
            c=orderDetailService.updateBatchById(collect);
        }

        //3.对出入库记录进行存储
        List<NormalInOutDto> inventorySumDtos = saveInOutRecords(req);

        //4.如果没有单据当作日常出入库或者采购时，需要对库存汇总表进行更新
        boolean d=false;
        if (req.getBussinessType().equals("normal")|| req.getBussinessType().equals("purchase")){
            //获取到组织机构和仓库，将出入库的装备进行分组统计，并且对inventorysummary进行更新操作
            d = updateNumToSum(req.getOutInState(), inventorySumDtos, req.getOutInState());
        }
        return (a && b && c && d);
    }

    //对库存汇总表进行更新（只限于日常出入库）
    public boolean updateNumToSum(String outInState,List<NormalInOutDto> inventorySumDtos,String OutInState) {

        List<NormalInOutDto> groupedResult = inventorySumDtos.stream()
                .collect(Collectors.groupingBy(dto -> dto.getOrgId() + "_" + dto.getLocationId() + "_" +
                                dto.getSizeId() + "_" + dto.getTypeId() + "_" + dto.getPrice(),
                        Collectors.collectingAndThen(Collectors.toList(), group -> {
                            NormalInOutDto result = new NormalInOutDto();
                            result.setOrgId(group.get(0).getOrgId());
                            result.setLocationId(group.get(0).getLocationId());
                            result.setSizeId(group.get(0).getSizeId());
                            result.setTypeId(group.get(0).getTypeId());
                            result.setPrice(group.get(0).getPrice());
                            result.setNumber(group.stream().mapToInt(NormalInOutDto::getNumber).sum());
                            return result;
                        })))
                .values().stream()
                .collect(Collectors.toList());
        //将查询条件存入searchCriteria中一次性查询出满足条件的数据
        List<Object[]> searchCriteria = new ArrayList<>();
        for (NormalInOutDto groupedDto : groupedResult) {
            Object[] criteria = new Object[]{groupedDto.getOrgId(), groupedDto.getLocationId(),
                    groupedDto.getTypeId(),groupedDto.getSizeId(), groupedDto.getPrice()};
            searchCriteria.add(criteria);
        }
        //满足条件的数据
        List<InventorySummary> inventorySummaryList = inventorySummaryMapper.selectSumByItems(searchCriteria);
        List<InventorySummary> addList=new ArrayList<>();
        List<InventorySummary> updateList=new ArrayList<>();
        //遍历两者，判断数据库中是否全部存在，如果不存在，则进行增加数据操作，如果存在，则更新数据即可
        for (NormalInOutDto outDto:groupedResult) {
            boolean flag=false;
            for (InventorySummary is:inventorySummaryList) {
                if (outDto.getOrgId()==is.getOrgId() && outDto.getLocationId().equals(is.getLocationId())
                    && outDto.getSizeId().equals(is.getSizeId()) && outDto.getTypeId().equals(is.getTypeId())
                    && outDto.getPrice().compareTo(is.getUnitPrice())==0){
                    if (outInState.equals("in")){
                        is.setOutboundNumber(is.getOutboundNumber()-outDto.getNumber());
                        is.setStockNumber(is.getStockNumber()+outDto.getNumber());
                        is.setPrice(is.getPrice().add(BigDecimal.valueOf(outDto.getNumber()).multiply(outDto.getPrice())) );
                    }else {
                        is.setOutboundNumber(is.getOutboundNumber()+outDto.getNumber());
                        is.setStockNumber(is.getStockNumber()-outDto.getNumber());
                        is.setPrice(is.getPrice().subtract(BigDecimal.valueOf(outDto.getNumber()).multiply(outDto.getPrice())) );
                    }
                    updateList.add(is);
                    flag=true;
                    break;
                }
            }
            if (!flag){
                InventorySummary inventorySummary = new InventorySummary();
                BeanPlusUtil.copyProperties(outDto,inventorySummary);
                inventorySummary.setPrice(BigDecimal.valueOf(outDto.getNumber()).multiply(outDto.getPrice()));
                inventorySummary.setUnitPrice(outDto.getPrice());
                inventorySummary.setBrokenNumber(0);
                inventorySummary.setExpireNumber(0);
                inventorySummary.setDestructionNumber(0);
                inventorySummary.setNearBrokenNumber(0);
                inventorySummary.setCreateTime(DateTimeUtil.getCurrentDateTime());
                if (outInState.equals("in")){
                    inventorySummary.setOutboundNumber(0);
                    inventorySummary.setUseNumber(0);
                    inventorySummary.setStockNumber(outDto.getNumber());
                }
                addList.add(inventorySummary);
            }
        }
        boolean a=true;
        if (addList.size()>0){
            boolean b = inventorySummaryService.saveBatch(addList);
            a = b;
        }
        if (updateList.size()>0){
            boolean b = inventorySummaryService.updateBatchById(updateList);
            a = a && b;
        }
        return a;
    }

    //对出入库记录进行存储
    public List<NormalInOutDto> saveInOutRecords(OutInLogsReq req) {
        //返回结果，用于日常出入库时计算更新库存汇总表
        List<NormalInOutDto> returnList=new ArrayList<>();
        List<LogDetail> logDetailList=new ArrayList<>();
        List<SummaryLogReq> logSummaryList = req.getLogSummaryList();
        //如果是日常出入库，那么将这些出入库数据进行计算，最终更新库存汇总表中的数据
        if (req.getBussinessType().equals("normal")){
            for (SummaryLogReq summaryLogReq:logSummaryList) {
                LogSummary logSummary = new LogSummary();
                BeanPlusUtil.copyProperties(summaryLogReq,logSummary);
                logSummary.setOutInState(req.getOutInState());
                logSummary.setCreateTime(DateTimeUtil.getCurrentDateTime());
                logSummary.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                logSummary.setBussinessType(req.getBussinessType());
                logSummary.setOrgId(req.getOrgId());
                logSummary.setOrgName(req.getOrgName());
                logSummaryService.save(logSummary);
                List<DetailLogReq> logList = summaryLogReq.getLogDetailList();
                //出入库list
                List<LogDetail> collect=new ArrayList<>();
                //用于装备汇总list
                List<NormalInOutDto> list=new ArrayList<>();
                for (DetailLogReq detailLogReq: logList) {
                    //将所有装备信息进行存放（为后面计算汇总信息）
                    NormalInOutDto normalInOutDto = new NormalInOutDto();
                    BeanPlusUtil.copyProperties(detailLogReq,normalInOutDto);
                    normalInOutDto.setLocationId(logSummary.getLocationId());
                    normalInOutDto.setLocationName(logSummary.getLocationName());
                    normalInOutDto.setOrgId(logSummary.getOrgId());
                    normalInOutDto.setOrgName(logSummary.getOrgName());
                    normalInOutDto.setNumber(1);
                    list.add(normalInOutDto);
                    //存放logdetail信息
                    LogDetail logDetail = new LogDetail();
                    BeanPlusUtil.copyProperties(detailLogReq, logDetail);
                    logDetail.setSummaryId(logSummary.getId());
                    collect.add(logDetail);
                }
                logDetailList.addAll(collect);
                returnList.addAll(list);
            }
            logDetailService.saveBatch(logDetailList);
            return returnList;
        }else {
            //外层的logSummary只能逐个进行插入，logDetail可以批量进行插入
            for (SummaryLogReq summaryLogReq:logSummaryList) {
                LogSummary logSummary = new LogSummary();
                BeanPlusUtil.copyProperties(summaryLogReq,logSummary);
                logSummary.setOutInState(req.getOutInState());
                logSummary.setCreateTime(DateTimeUtil.getCurrentDateTime());
                logSummary.setUpdateTime(DateTimeUtil.getCurrentDateTime());
                logSummary.setBussinessType(req.getBussinessType());
                logSummary.setOrgId(req.getOrgId());
                logSummary.setOrgName(req.getOrgName());
                logSummaryService.save(logSummary);
                List<LogDetail> collect = summaryLogReq.getLogDetailList().stream().map(detailLogReq -> {
                    LogDetail logDetail = new LogDetail();
                    NormalInOutDto inventorySumDto = new NormalInOutDto();
                    BeanPlusUtil.copyProperties(detailLogReq,inventorySumDto);
                    BeanPlusUtil.copyProperties(detailLogReq, logDetail);
                    logDetail.setSummaryId(logSummary.getId());
                    return logDetail;
                }).collect(Collectors.toList());
                logDetailList.addAll(collect);
            }
            logDetailService.saveBatch(logDetailList);
            return returnList;
        }

    }

}




