package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.dto.CabinetDto;
import com.junmp.jyzb.api.bean.query.CabinetBoxReq;
import com.junmp.jyzb.api.bean.query.CabinetReq;
import com.junmp.jyzb.api.bean.req.UpdateCabinetReq;
import com.junmp.jyzb.entity.Cabinet;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;
import java.util.Map;

public interface CabinetService extends IService<Cabinet> {


    /**
     * 添加单警柜
     * @param req
     * @return
     */
    String addCabinetInfo(UpdateCabinetReq req) ;

    /**
     * 删除单警柜
     * @param req
     * @return
     */
    boolean deleteCabinetInfo(UpdateCabinetReq req);

    /**
     * 查询单警柜信息，通过组织机构id进行查询
     * @param req
     * @return
     */
    List<CabinetDto> getAllCabinetList(CabinetReq req);



    /**
     * 通过单警柜id进行查询单个单警柜信息及其箱门信息
     * @param req
     * @return
     */
    CabinetDto showOneCabinet(CabinetReq req);

    /**
     * 修改单警柜信息，平台使用
     * @param req
     * @return
     */
    boolean updateCabinetInfo(UpdateCabinetReq req);

    /**
     * 修改单警柜信息，警柜使用
     * @param req
     * @return
     */
    boolean updateCabinetClient(UpdateCabinetReq req);
    /**
     * 箱门绑定人员
     * @param req
     * @return
     */
    boolean boxBindPolice(CabinetBoxReq req);


    /**
     * 修改单警柜箱门状态
     * @param req
     * @return
     */
    boolean ChangeCabinetState(UpdateCabinetReq req);

    //根据单警柜id查询出组织机构id
    Long SearchOrgId(CabinetReq req);

    //判断单警柜是否存在
    Cabinet CabinetExist(String id);

    boolean SetInventoryInfo(String id);

    //根据组织机构id查询出单警柜的详细信息(page)
    PageResult<CabinetDto> ShowCabinetPage(CabinetReq req);
}
