package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.InventorySumDto;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.FinalTjOrgPriceDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgEqsDto;
import com.junmp.jyzb.api.bean.dto.TjDto.TjOrgPriceDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgEqsReq;
import com.junmp.jyzb.api.bean.query.TjReq.TjOrgPriceReq;
import com.junmp.jyzb.service.TjService;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Tj")
@Api(tags = "统计报表模块")
public class TjController {

   @Resource
   private TjService tjService;

    /**
     * 根据组织机构统计装备的报表数据（外层数据）
     */
    @PostMapping("/TjOrgEqs")
    @ApiOperation("/装备统计报表")
    public ApiRes<FinalTjOrgEqsDto> TjOrgEqs(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqs(req));
    }
    //装备统计报表（点击+后里面的数据）
    @PostMapping("/TjOrgEqsDetail")
    @ApiOperation("/根据添加查询组织机构下的装备统计")
    public ApiRes<List<InventorySumDto>> TjOrgEqsDetail(@RequestBody TjOrgEqsReq req){
        return ApiRes.success(tjService.TjOrgEqsDetail(req));
    }

    //财务统计报表
    @PostMapping("/TjOrgPrice")
    @ApiOperation("/财务统计报表")
    public ApiRes<FinalTjOrgPriceDto> TjOrgPrice(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPrice(req));
    }

    //财务统计报表（点击+后里面的数据）
    @PostMapping("/TjOrgPriceDetail")
    @ApiOperation("/根据添加查询组织机构下的财务统计")
    public ApiRes<List<TjOrgPriceDto>> TjOrgPriceDetail(@RequestBody TjOrgPriceReq req){
        return ApiRes.success(tjService.TjOrgPriceDetail(req));
    }




    @PostMapping("test")
    public ApiRes<List<TjOrgEqsDto>> test(@RequestBody InventoryReq req){
        return ApiRes.success(tjService.test(req));
    }
}
