package com.junmp.jyzb.api.exception.enums;

import com.junmp.v2.common.constant.CommonConstant;
import com.junmp.v2.common.exception.IExceptionEnum;
import lombok.Getter;

@Getter
public enum PubOrgExceptionEnum implements IExceptionEnum {
    /**
     * 组织机构不存在
     */
    PUBORG_NOT_EXIST(CommonConstant.DEFAULT_USER_ERROR_CODE,"组织机构不存在"),
    /**
     * 组织机构不存在或者被删除
     */
    PUBORG_NOTEXIST_OR_DEL(CommonConstant.DEFAULT_USER_ERROR_CODE,"组织机构不存在或者已经被删除"),
    ;

    /**
     * 错误编码
     */
    private final Integer code;

    /**
     * 提示用户信息
     */
    private final String message;

    PubOrgExceptionEnum(Integer code, String message) {
        this.code = code;
        this.message = message;
    }
}
