package com.junmp.junmpProcess.listener;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.map.MapUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.junmp.junmpProcess.dto.UserListDTO;
import com.junmp.junmpProcess.dto.json.*;
import com.junmp.junmpProcess.exception.WorkFlowException;
import com.junmp.junmpProcess.mapper.OrgUserMapper;
import com.junmp.junmpProcess.service.Repository.ProcessTemplateService;
import com.junmp.v2.sys.api.UserServiceApi;
import com.junmp.v2.sys.api.bean.user.dto.RoleUserDto;
import com.junmp.v2.sys.api.bean.user.vo.QueryUserInfoVo;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.UserTask;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.delegate.DelegateExecution;
import org.flowable.engine.delegate.ExecutionListener;
import com.junmp.junmpProcess.enums.AssigneeTypeEnums;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.junmp.junmpProcess.utils.BpmnModelUtils.getChildNode;

/**
 * @author LoveMyOrange
 * @create 2022-10-15 13:35
 */
@Component
public class CounterSignListener implements ExecutionListener {
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private OrgUserMapper orgUserMapper;
    @Override
    public void notify(DelegateExecution execution) {
        String currentActivityId = execution.getCurrentActivityId();
        Process mainProcess = repositoryService.getBpmnModel(execution.getProcessDefinitionId()).getMainProcess();
        UserTask userTask = (UserTask) mainProcess.getFlowElement(currentActivityId);
        String flowJson = mainProcess.getAttributeValue("http://flowable.org/bpmn", "Junmp");
        JSONObject jsonObject = JSONObject.parseObject(flowJson, new TypeReference<JSONObject>() {
        });
        String processJson = jsonObject.getString("processJson");
        ChildNode childNode = JSONObject.parseObject(processJson, new TypeReference<ChildNode>() {
        });
        List<String> assigneeList = new ArrayList<>();
        String variable = currentActivityId + "assigneeList";
        List usersValue = (List) execution.getVariable(variable);
        if (usersValue == null) {

            ChildNode currentNode = getChildNode(childNode, currentActivityId);
            if (currentNode == null) {
                throw new WorkFlowException("查找审批人失败,请联系管理员重试");
            }
            ApproverGroups group=currentNode.getApproverGroups().get(0);
            String Type=group.getApproverType();
            if (Type.equals("1"))//指定人员，不处理
            {
                List<String> assignedUser = group.getApproverIds();
                for (String userInfo : assignedUser) {
                    assigneeList.add(userInfo);
                }


            }
            else if (Type.equals("2"))//指定角色
            {
                List<String> Roles=group.getApproverIds();
                if (Roles.size()>0)//角色不为空
                {
                    //开始拼接传入的多角色
                    String roleList="(";
                    for (String role :Roles)
                    {
                        roleList+=role+",";
                    }

                    roleList = roleList.substring(0, roleList.length() - 1);
                    roleList+=")";//至此拼接完成

                    List<UserListDTO> userList=orgUserMapper.QueryUserByRoleId(roleList);
                        for (UserListDTO userId :userList)
                        {
                            assigneeList.add(userId.getUserID());
                        }


                }


            }
            else if (Type.equals("3"))//指定组织机构中的角色
            {
//                List<UserListDTO> userList=orgUserMapper.QueryUserByRoleIdAndOrg(role);
                List<String> Roles=group.getApproverIds();
                List<String> Orgs=group.getOrgIds();
                if (Roles.size()>0&&Orgs.size()>0)//角色不为空,组织机构不为空
                {
                    //开始拼接传入的多角色
                    String roleList="(";
                    for (String role :Roles)
                    {
                        roleList+=role+",";
                    }

                    roleList = roleList.substring(0, roleList.length() - 1);
                    roleList+=")";//至此拼接完成

                    //开始拼接传入的多组织机构
                    String orgList="(";
                    for (String org :Orgs)
                    {
                        orgList+=org+",";
                    }

                    orgList = orgList.substring(0, orgList.length() - 1);
                    orgList+=")";//至此拼接完成

                    List<UserListDTO> userList=orgUserMapper.QueryUserByRoleIdAndOrg(roleList,orgList);
                    for (UserListDTO userId :userList)
                    {
                        assigneeList.add(userId.getUserID());
                    }


                }

            }
            if (assigneeList.size()!=0)
            {execution.setVariable(variable, assigneeList);}

        } else {
        }
    }
}
