package com.junmp.jyzb.service;

import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.jyzb.api.bean.req.ProductSkuReq;
import com.junmp.jyzb.entity.ProductSku;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/29 16:25
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
public interface ProductSkuService extends IService<ProductSku> {

    /**
     * 新增
     *
     * @param req
     */
    boolean addProductSku(ProductSkuReq req);

    /**
     * 编辑
     *
     * @param req
     */
    boolean editProductSku(ProductSkuReq req);

    /**
     * 删除
     *
     * @param req
     */
    boolean del(ProductSkuReq req);

    /**
     * 删除产品关联的号型
     *
     * @param productId
     */
    boolean delByProductId(Long productId);


    /**
     * 列表信息
     *
     * @param req
     */
    List<ProductSku> findList(ProductSkuReq req);

    /**
     * 分页信息
     *
     * @param req
     */
    PageResult<ProductSku> findPage(ProductSkuReq req);
}
