package com.junmp.jyzb.api.bean.req;

import com.junmp.v2.common.bean.request.BaseRequest;
import com.junmp.v2.validator.api.validators.unique.TableUniqueValue;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/8/1 16:29
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class ProductReq extends BaseRequest {

    @NotNull(message = "产品主键不能为空", groups = {edit.class, delete.class, detail.class})
    private Long productId;

    /**
     * 产品代码
     */
    @NotBlank(message = "产品编码不能为空", groups = {edit.class})
    @TableUniqueValue(
            message = "编码重复",
            groups = {edit.class},
            tableName = "biz_product",
            columnName = "product_code",
            idFieldName = "product_id")
    private String productCode;

    /**
     * 产品当前序号
     */
    private Integer sn;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 条码信息
     */
    private String barcode;

    /**
     * 重量
     */
    private String weight;

    /**
     * 规格尺寸
     */
    private String spec;

    /**
     * 材质
     */
    private String material;


    /**
     * 计量单位
     */
    private String unit;

    /**
     * 广告信息
     */
    private String adInfo;

    /**
     * 图片地址
     */
    private String imageUrl;


    /**
     * 生产厂家编号
     */
    private Long mfBizId;

    /**
     * 生产厂家名称
     */
    private String mfBizName;
}
