package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.domain.PubOrg;
import com.junmp.jyzb.service.CabinetService;
import com.junmp.jyzb.service.InventoryService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnMsg;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.InventoryMapper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class InventoryServiceImpl implements InventoryService {

    @Resource
    private InventoryMapper inventoryMapper;

    @Resource
    private WarehouseService warehouseService;

    @Resource
    private CabinetService cabinetService;

    @Override
    public ResponseResult getEquipmentInfo(Map<String, Object> inMsg) {
        //参数校验
        try {
            checkNotBlank(inMsg.get("queryType"), "queryType不能为空");
            checkNotBlank(inMsg.get("typeId"), "typeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //解析json中的信息
        String queryType = inMsg.get("queryType").toString();
        String idMsg = inMsg.get("typeId").toString();

        //根据传入的queryType来辨别要查询什么信息
        if (queryType.equals("org") || queryType.equals("warehouse") || queryType.equals("cabinet")){
            Map<String,Object> returnMsg = getLocationEquipmentInfo(queryType,idMsg);
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
        }else {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"输入的queryType信息有误");
        }

    }

    private Map<String, Object> getLocationEquipmentInfo(String queryType, String idMsg) {
        List<Map<String, Object>> allMsg = inventoryMapper.getLocationInventory(queryType,idMsg);

        Map<String, Object> resultMap = new HashMap<>();
        for (Map<String, Object> msg : allMsg) {
            String locationId = msg.get("locationId").toString();
            String locationName = msg.get("locationName").toString();
            String typeId = msg.get("typeId").toString();
            String typeName = msg.get("typeName").toString();
            String sizeId = msg.get("sizeId").toString();
            String sizeName = msg.get("sizeName").toString();
            int number = (int) msg.get("number");
            BigDecimal priceBigDecimal = (BigDecimal) msg.get("price");
            float price = priceBigDecimal.floatValue();

            //检查resultMap中是否存在orgId
            if (resultMap.containsKey(locationId)) {
                // 获取现有组织级数据
                Map<String, Object> orgData = (Map<String, Object>) resultMap.get(locationId);
                List<Map<String, Object>> orgTypeList = (List<Map<String, Object>>) orgData.get("typeList");

                // 检查组织类型列表中是否存在typeId
                boolean typeExist = false;
                for (Map<String, Object> typeData : orgTypeList) {
                    if (typeId.equals(typeData.get("typeId"))) {
                        // 获取现有的类型级别数据
                        List<Map<String, Object>> sizeList = (List<Map<String, Object>>) typeData.get("sizeList");
                        sizeList.add(createSizeData(sizeId,sizeName, number,price)); //向sizeList中记录number的信息
                        int typeNumber = (int) typeData.get("typeNum");
                        float typePrice = (float) typeData.get("typeTotalPrice");
                        typeData.put("typeNum", typeNumber + number); //计算装备数量
                        typeData.put("typeTotalPrice", typePrice + price);
                        typeExist = true;
                        break;
                    }
                }

                // 如果 orgTypeList 中不包含 typeId，则创建新的类型级别数据
                if (!typeExist) {
                    Map<String, Object> typeData = new HashMap<>();
                    typeData.put("typeId", typeId);
                    typeData.put("typeName", typeName);
                    typeData.put("typeNum", number);
                    typeData.put("typeTotalPrice", price);
                    List<Map<String, Object>> sizeList = new ArrayList<>();
                    sizeList.add(createSizeData(sizeId,sizeName, number,price));
                    typeData.put("sizeList", sizeList);
                    orgTypeList.add(typeData);
                }

                // 更新组织级别数据
                int orgNumber = (int) orgData.get("locationNum");
                float orgPrice = (float) orgData.get("totalPrice");
                orgData.put("locationNum", orgNumber + number);
                orgData.put("totalPrice", orgPrice + price);
            } else {
                // 创建新的组织级别数据
                Map<String, Object> orgData = new HashMap<>();
                orgData.put("locationType", queryType);
                orgData.put("locationId", locationId);
                orgData.put("locationName", locationName);
                orgData.put("locationNum", number);
                orgData.put("totalPrice", price);
                List<Map<String, Object>> orgTypeList = new ArrayList<>();
                Map<String, Object> typeData = new HashMap<>();
                typeData.put("typeId", typeId);
                typeData.put("typeName", typeName);
                typeData.put("typeNum", number);
                typeData.put("typeTotalPrice", price);
                List<Map<String, Object>> sizeList = new ArrayList<>();
                sizeList.add(createSizeData(sizeId,sizeName, number,price));
                typeData.put("sizeList", sizeList);
                orgTypeList.add(typeData);
                orgData.put("typeList", orgTypeList);
                resultMap.put(locationId, orgData);
            }
        }
        Map<String,Object> returnMsg = (Map<String, Object>) resultMap.get(idMsg);
        return returnMsg;
    }

    private static Map<String, Object> createSizeData(String sizeId,String sizeName, int number,float price) {
        Map<String, Object> sizeData = new HashMap<>();
        sizeData.put("sizeId", sizeId);
        sizeData.put("sizeName", sizeName);
        sizeData.put("sizeNum", number);
        sizeData.put("sizeTotalPrice", price);
        return sizeData;
    }

    @Override
    public ResponseResult setInventoryMsg(){
        inventoryMapper.deleteAllMsg(); //清空数据库中已存在的信息

        //inventoryMapper.setOrgInventory(); //放入组织机构信息汇总

        inventoryMapper.setCabinetInventory(); //放入组织机构信息汇总

        inventoryMapper.setWarehouseInventory(); //放入组织机构信息汇总
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult updateInventoryNum(Map<String, Object> msg) {
        //参数校验
        try {
            checkNotBlank(msg.get("locationType"), "locationType不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String locationType = msg.get("locationType").toString();
        if (!locationType.equals("warehouse") && !locationType.equals("cabinet")){
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"输入的locationType值有误");
        }else if(locationType.equals("warehouse")){
            warehouseService.setWarehouseInventory(msg);
        }else if(locationType.equals("cabinet")){
            cabinetService.setCabinetInventory(msg);
        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult getInventoryList(Map<String, Object> msg) {
        //参数校验
        try {
            checkNotBlank(msg.get("queryType"), "queryType不能为空");
            checkNotBlank(msg.get("typeCode"), "typeCode不能为空");
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
            checkNotBlank(msg.get("sizeId"), "sizeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }

        //解析json中的信息
        String queryType = msg.get("queryType").toString();
        String typeCode = msg.get("typeCode").toString();
        String typeId = msg.get("typeId").toString();
        String sizeId = msg.get("sizeId").toString();

        //根据传入的queryType来辨别要查询什么信息
        if (queryType.equals("org") || queryType.equals("warehouse") || queryType.equals("cabinet")){
            List<Map<String,Object>> returnMsg = inventoryMapper.getInventoryList(queryType,typeCode,typeId,sizeId);
            return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
        }else {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,"输入的queryType信息有误");
        }
    }

    @Override
    public ResponseResult getInventoryByOrgId(Map<String, Object> msg) {
        //参数校验
        try {
            checkNotBlank(msg.get("orgId"), "orgId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR,e.getMessage());
        }
        String orgId = msg.get("orgId").toString();
        List<Map<String,Object>> returnMsg = inventoryMapper.getInventoryByOrgId(orgId);
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }

    @Override
    public ResponseResult getInventoryDevelop() {
        return null;
    }
}
