package com.junmp.jyzb.service.impl;

import com.junmp.jyzb.domain.EquipmentType;
import com.junmp.jyzb.domain.PubOrg;
import com.junmp.jyzb.mapper.SupplierMapper;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.utils.*;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.EquipmentTypeMapper;

import java.util.*;

import static com.junmp.jyzb.utils.CheckBlank.checkNotBlank;

@Service
public class EquipmentTypeServiceImpl implements EquipmentTypeService {

    @Resource
    private RedisUtils redisUtils;

    @Resource
    private EquipmentTypeMapper equipmentTypeMapper;

    @Resource
    private SupplierMapper supplierMapper;

    private static final String REDIS_TYPE = "Type_";

    @Override
    public ResponseResult getEquipmentList() {
        List<EquipmentType> menuList = equipmentTypeMapper.selectAllEquipment();

        List<Map<String, Object>> topList = new ArrayList<>();
        List<Map<String, Object>> resultList = new ArrayList<>();
        Map<String, List<Map<String, Object>>> childrenMap = new HashMap<>();

        // 构建子菜单映射表
        for (EquipmentType menu : menuList) {
            Map<String, Object> map = new HashMap<>();
            map.put("id", menu.getId());
            map.put("name", menu.getName());
            map.put("unit", menu.getUnit());
            map.put("unitType", menu.getUnitType());
            map.put("code", menu.getCode());
            map.put("parentId", menu.getParentId());
            map.put("state", menu.getState());
            map.put("note", menu.getNote());
            map.put("createTime", menu.getCreateTime());
            map.put("updateTime", menu.getUpdateTime());
            map.put("type",menu.getType());

            //如果是id和parentId都为 00000 的超级根，就将它放在映射为-1的数据中
            if (menu.getId().equals("00000000-0000-0000-0000-000000000000") && menu.getParentId().equals("00000000-0000-0000-0000-000000000000")){
                childrenMap.put("-1", new ArrayList<>());
                childrenMap.get("-1").add(map);
                continue;
            }

            if (!childrenMap.containsKey(menu.getParentId())) {
                childrenMap.put(menu.getParentId(), new ArrayList<>());
            }

            childrenMap.get(menu.getParentId()).add(map);
        }

        // 获取顶级菜单(最高一级的parentId 为 -1)
        List<Map<String, Object>> topMenus = childrenMap.get("-1");

        // 迭代构建菜单树
        if (topMenus != null) {

            for (Map<String, Object> topMenu : topMenus) {
                Stack<Map<String, Object>> stack = new Stack<>();
                stack.push(topMenu);

                // 使用栈进行深度优先遍历
                while (!stack.isEmpty()) {
                    Map<String, Object> currentMenu = stack.pop();
                    String currentMenuId = currentMenu.get("id").toString();

                    if (childrenMap.containsKey(currentMenuId)) {
                        List<Map<String, Object>> children = childrenMap.get(currentMenuId);
                        currentMenu.put("children", children);

                        for (int i = children.size() - 1; i >= 0; i--) {
                            stack.push(children.get(i));
                        }
                    }
                }
                resultList.add(topMenu);
            }
        }
        // 返回结果
        return new ResponseResult(HttpStatus.SUCCESS, "操作成功", resultList);
    }





//    @Override
//    public List<Map<String, Object>> getEquipmentList() {
//        List<EquipmentType> menuList = equipmentTypeMapper.selectAllEquipment();
//        List<Map<String, Object>> resultList = new ArrayList<>();
//        for (EquipmentType menu : menuList) {
//            //System.out.println(menu.getIdByParentId()+"  "+menu.getName()+"  "+menu.getParentId());
//            //00000000-0000-0000-0000-000000000000
//            //List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
//            if (!menu.getName().equals("超级根") && menu.getParentId().equals("00000000-0000-0000-0000-000000000000")) {
//                //List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
//                Map<String, Object> map = new HashMap<>();
//                map.put("id", menu.getId());
//                map.put("name", menu.getName());
//                map.put("unit", menu.getUnit());
//                map.put("unitType", menu.getUnitType());
//                map.put("code", menu.getCode());
//                map.put("parentId", menu.getParentId());
//                map.put("state", menu.getState());
//                map.put("note", menu.getNote());
//                map.put("createTime", menu.getCreateTime());
//                map.put("updateTime", menu.getUpdateTime());
//
//                //map.put("children", children);
//                List<Map<String, Object>> children = getChildMenus(menu.getId(),menuList);
//                if (!children.isEmpty()) {
//                    map.put("children", children);
//                }
//
//                resultList.add(map);
//            }
//        }
///*
//        //将查询结果存入 Redis 中
//        redisUtils.set(redisKey, resultList);
//*/
//        return resultList;
//    }

//    private List<Map<String, Object>> getChildMenus(String parentId, List<EquipmentType> menuList) {
//        List<Map<String, Object>> childList = new ArrayList<>();
//        for (EquipmentType menu : menuList) {
//            if (menu.getParentId().equals(parentId)) {
//                Map<String, Object> map = new HashMap<>();
//                map.put("id", menu.getId());
//                map.put("name", menu.getName());
//                map.put("unit", menu.getUnit());
//                map.put("unitType", menu.getUnitType());
//                map.put("code", menu.getCode());
//                map.put("parentId", menu.getParentId());
//                map.put("state", menu.getState());
//                map.put("note", menu.getNote());
//                map.put("createTime", menu.getCreateTime());
//                map.put("updateTime", menu.getUpdateTime());
//
//                List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
//                if (!children.isEmpty()) {
//                    map.put("children", children);
//                }
//
//                childList.add(map);
//            }
//        }
//        return childList;
//    }

    @Override
    public ResponseResult addEquipment(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("parentId"), "parentId不能为空");
            checkNotBlank(msg.get("supplierList"), "supplierList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        //parentId只能是倒数第二级，因为插入的装备只能是最后一级
        String resultId = equipmentTypeMapper.getIdByParentId((String) msg.get("parentId"));
        if (resultId == null || resultId.equals("")) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "传入的parentId有误，新的装备类型只能加在最后一级");
        }

        //判断传入的组织机构是否存在
        List<String> supplierFlag = new ArrayList<>();
        List<String> supplierList = (List<String>) msg.get("supplierList");
        for (String supplierId : supplierList) {
            Map<String, Object> oneSupplier = supplierMapper.getOneSupplier(supplierId, null, null);
            if (oneSupplier == null || oneSupplier.isEmpty()) {
                supplierFlag.add(supplierId);
            }
        }
        if (!supplierFlag.isEmpty()) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "传入的部分供应商不存在：" + supplierFlag);
        }

        EquipmentType equipmentType = new EquipmentType();
        //生成加入supplier-type表的uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");

        //生成时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        equipmentType.setCreateTime(currentDate);
        equipmentType.setUpdateTime(currentDate);

        //计算出新的装备类型id，在原来的基础上+1
        int num = Integer.parseInt(resultId);
        String numStr = String.valueOf(num + 1);

        //读取json中的相关数据
        equipmentType.setId(numStr);
        equipmentType.setName((String) msg.get("name"));
        equipmentType.setUnitType((String) msg.get("unitType"));
        equipmentType.setCode(numStr);
        equipmentType.setParentId((String) msg.get("parentId"));
        equipmentType.setNote((String) msg.get("note"));

        //计算出id后，判断数据库中是否已存在该id
        String oneEquipment = equipmentTypeMapper.getOneEquipmentId(numStr);
        if (!(oneEquipment == null)) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "添加异常，装备id已存在");
        }

        //读取装备的供应商列表,将相关数据加入到supplier_type表
        equipmentTypeMapper.addSupplier(uuid, equipmentType, supplierList);

        //更新base_equipment_id表
        equipmentTypeMapper.setCalculationId(numStr, (String) msg.get("parentId"));

        equipmentTypeMapper.addEquipment(equipmentType);

//        // 将uuid、创建时间、更新时间加入到msg中
//        msg.put("id",numStr);
//        long timestamp = currentDate.getTime(); // 将Date对象转换为long类型的时间戳
//        msg.put("updateTime",timestamp);
//
//        /**
//         * 更新缓存
//         * */
//        //构建Redis缓存键
//        String redisKey = REDIS_TYPE;
//        // 从 Redis 中获取数据
//        List<Map<String, Object>> cachedData = redisUtils.findCachedData(redisKey);
//        if (cachedData != null) {
//            cachedData.add(0,msg);
//            //将查询结果存入 Redis 中
//            redisUtils.set(redisKey, cachedData);
//
//        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, numStr);
    }

    @Override
    public ResponseResult calculationEquipmentId() {
        List<Map<String, Object>> inputList = equipmentTypeMapper.getAll();
        // 假设您已经有了填充数据的inputList
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (int i = 0; i < inputList.size() - 1; i++) {
            Map<String, Object> currentMap = inputList.get(i);
            Map<String, Object> nextMap = inputList.get(i + 1);
            int currentId = (int) currentMap.get("id");
            int nextId = (int) nextMap.get("id");
            if (currentId + 1 != nextId) {
                resultList.add(currentMap);
            }
        }
        equipmentTypeMapper.addData(resultList);
        return new ResponseResult(99200, ReturnMsg.PASS, resultList);
    }

    @Override
    public ResponseResult deleteEquipment(Map<String, Object> msg) {
        // 进行参数校验
        try {
            checkNotBlank(msg.get("equipmentList"), "equipmentList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        List<Object> equipmentList = (List<Object>) msg.get("equipmentList");
        for (Object equipmentId : equipmentList) {
            //判断装备id在数据库中是否存在
            equipmentTypeMapper.deleteEquipment(equipmentId.toString());
        }
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult updateEquipment(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            checkNotBlank(msg.get("name"), "name不能为空");
            checkNotBlank(msg.get("parentId"), "parentId不能为空");
            checkNotBlank(msg.get("supplierList"), "supplierList不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

//        //parentId只能是倒数第二级，因为插入的装备只能是最后一级
//        String resultId = equipmentTypeMapper.getIdByParentId((String) msg.get("parentId"));
//        if (resultId == null || resultId.equals("")){
//            return new ResponseResult(HttpStatus.ERROR,ReturnMsg.ERROR,"传入的parentId有误，新的装备类型只能加在最后一级");
//        }

        //判断传入的供应商是否存在
        List<String> supplierFlag = new ArrayList<>();
        List<String> supplierList = (List<String>) msg.get("supplierList");
        for (String supplierId : supplierList) {
            Map<String, Object> oneSupplier = supplierMapper.getOneSupplier(supplierId, null, null);
            if (oneSupplier == null || oneSupplier.isEmpty()) {
                supplierFlag.add(supplierId);
            }
        }
        if (supplierFlag != null) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "传入的部分供应商不存在：" + supplierFlag);
        }

        //计算出id后，判断数据库中是否已存在该id
        String oneEquipment = equipmentTypeMapper.getOneEquipmentId(msg.get("id").toString());
        if (oneEquipment == null || oneEquipment.equals("")) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, "未查询到相应的装备类型");
        }

        EquipmentType equipmentType = new EquipmentType();
        //生成加入supplier-type表的uuid
        String uuid = UUID.randomUUID().toString().replaceAll("-", "");

        //修改警员相关信息
        //生成当前时间
        Date currentDate = DateTimeUtil.getCurrentDateTime();
        equipmentType.setCreateTime(currentDate);
        equipmentType.setUpdateTime(currentDate);
        //police.setId(uuid);
        equipmentType.setId((String) msg.get("id"));
        equipmentType.setName((String) msg.get("name"));
        equipmentType.setUnitType((String) msg.get("unitType"));
        //equipmentType.setCode((String) msg.get("code"));
        equipmentType.setParentId((String) msg.get("parentId"));
        equipmentType.setNote((String) msg.get("note"));

//        equipmentType.set((String) msg.get("updateUser"));
//        equipmentType.setLocation((String) msg.get("location"));
//        equipmentType.setPhone((String) msg.get("phone"));
//        equipmentType.setUpdateTime(currentDate);
//        equipmentType.setOrgId((String) msg.get("orgId"));

        //删除装备的所有供应商信息，在将相关数据加入到supplier_type表
        equipmentTypeMapper.deleteSupplier(equipmentType.getId());
        //读取装备的供应商列表,将相关数据加入到supplier_type表
        equipmentTypeMapper.addSupplier(uuid, equipmentType, supplierList);

        equipmentTypeMapper.updateEquipment(equipmentType);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public ResponseResult changeEquipmentState(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("id"), "id不能为空");
            Objects.requireNonNull(msg.get("state"), "state不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        EquipmentType equipment = new EquipmentType();
        equipment.setId(msg.get("id").toString());
        equipment.setState((Integer) msg.get("state"));
        equipmentTypeMapper.changeEquipmentState(equipment);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }


    @Override
    public ResponseResult getOneEquipment(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("typeId"), "typeId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        EquipmentType equipment = new EquipmentType();
        equipment.setId(msg.get("typeId").toString());

        Map<String, Object> oneEquipment = equipmentTypeMapper.getOneEquipment(equipment);
        //返回对应的供应商信息
        List<Map<String, Object>> supplierMsg = equipmentTypeMapper.getSupplierByTypeId(equipment);
        oneEquipment.put("supplierList", supplierMsg);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, oneEquipment);
    }

    @Override
    public ResponseResult showEquipmentChildren(Map<String, Object> msg) {
        try {
            checkNotBlank(msg.get("equipmentId"), "equipmentId不能为空");
        } catch (IllegalArgumentException e) {
            return new ResponseResult(HttpStatus.ERROR, ReturnMsg.ERROR, e.getMessage());
        }

        String equipmentId = msg.get("equipmentId").toString();
        List<Map<String, Object>> equipmentMsg = equipmentTypeMapper.getChildByParentId(equipmentId);

        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS, equipmentMsg);
    }

    @Override
    public ResponseResult setTypeParentIds() {
        //清空parent_ids字段
        equipmentTypeMapper.wipeParentIdsData();
        //更新parent_ids字段
        equipmentTypeMapper.setTypeParentIds();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS);
    }

    @Override
    public List<Map<String, Object>> showAllEquipment() {
        List<EquipmentType> menuList = equipmentTypeMapper.selectAllEquipment();
        List<Map<String, Object>> resultList = new ArrayList<>();
        for (EquipmentType menu : menuList) {
            //System.out.println(menu.getIdByParentId()+"  "+menu.getName()+"  "+menu.getParentId());
            //00000000-0000-0000-0000-000000000000
            //List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
            if (!menu.getName().equals("超级根") && menu.getParentId().equals("00000000-0000-0000-0000-000000000000")) {
                //List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getId());
                map.put("name", menu.getName());
                map.put("unit", menu.getUnit());
                map.put("unitType", menu.getUnitType());
                map.put("code", menu.getCode());
                map.put("parentId", menu.getParentId());
                map.put("state", menu.getState());
                map.put("note", menu.getNote());
                map.put("createTime", menu.getCreateTime());
                map.put("updateTime", menu.getUpdateTime());
                //去掉最后一级children只能加两次
                //map.put("children", children);
                List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
                if (!children.isEmpty()) {
                    map.put("children", children);
                }
                resultList.add(map);
            }
        }
        return resultList;
    }

    @Override
    public ResponseResult getEquipmentDevelop() {
        List<Map<String,Object>> returnMsg = equipmentTypeMapper.getEquipmentDevelop();
        return new ResponseResult(HttpStatus.SUCCESS, ReturnMsg.PASS,returnMsg);
    }

    private List<Map<String, Object>> getChildMenus(String parentId, List<EquipmentType> menuList) {
        List<Map<String, Object>> childList = new ArrayList<>();
        for (EquipmentType menu : menuList) {
            if (menu.getParentId().equals(parentId)) {
                Map<String, Object> map = new HashMap<>();
                map.put("id", menu.getId());
                map.put("name", menu.getName());
                map.put("unit", menu.getUnit());
                map.put("unitType", menu.getUnitType());
                map.put("code", menu.getCode());
                map.put("parentId", menu.getParentId());
                map.put("state", menu.getState());
                map.put("note", menu.getNote());
                map.put("createTime", menu.getCreateTime());
                map.put("updateTime", menu.getUpdateTime());

                List<Map<String, Object>> children = getChildMenus(menu.getId(), menuList);
                if (!children.isEmpty()) {
                    map.put("children", children);
                }

                childList.add(map);
            }
        }
        return childList;
    }
}

