package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/29 16:16
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@TableName("biz_product_tag")
public class ProductTag implements Serializable {

    /**
     * 标签编号
     */
    @TableId(value = "tag_id", type = IdType.AUTO)
    private Long tagId;

    /**
     * RFID uid
     */
    @TableField(value = "tag_uid")
    private String tagUid;

    /**
     * 成品码
     */
    @TableField(value = "product_code")
    private String productCode;

    /**
     * 关联生成批次编号
     */
    @TableField(value = "batch_id")
    private Long batchId;

    /**
     * 关联生成产品主键
     */
    @TableField(value = "product_id")
    private Long productId;

    /**
     * 关联生成号型主键
     */
    @TableField(value = "spec_id")
    private Long specId;

    /**
     * 产品序号
     */
    @TableField(value = "serial_id")
    private Integer serialId;

    /**
     * 版本编号
     */
    @TableField(value = "version_no")
    private String versionNo;

    /**
     * 密文内容
     */
    private String ciphertext;

    /**
     * 生产日期
     */
    @TableField(value = "produce_time")
    private Date produceTime;

    /**
     * 复检时间
     */
    @TableField(value = "check_time")
    private Date checkTime ;

    /**
     * 密码
     */
    private String password;

    /**
     * 是否初始化
     */
    @TableField(value = "has_init")
    private Boolean hasInit ;

    /**
     * 是否复检
     */
    @TableField(value = "has_checked")
    private Boolean hasChecked;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;
}
