package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * <pre>
 *
 * 描述：
 * 版本：1.0.0
 * 日期：2022/7/29 16:54
 * 作者：ningzp@junmp.com.cn
 * <br>修改记录
 * <br>修改日期        修改人          修改内容
 *
 * </pre>
 */
@Data
@TableName("biz_product")
public class Product implements Serializable {

    @TableId(value = "product_id", type = IdType.AUTO)
    private Long productId;

    /**
     * 产品代码
     */
    @TableField("product_code")
    private String productCode;

    /**
     * 产品当前序号
     */
    private Integer sn;

    /**
     * 产品名称
     */
    private String name;

    /**
     * 条码信息
     */
    private String barcode;

    /**
     * 计量单位
     */
    private String unit;

    /**
     * 重量
     */
    private String weight;

    /**
     * 规格尺寸
     */
    private String spec;

    /**
     * 材质
     */
    private String material;

    /**
     * 图片地址
     */
    @TableField("image_url")
    private String imageUrl;


    /**
     * 生产厂家编号
     */
    @TableField("mf_biz_id")
    private Long mfBizId;

    /**
     * 生产厂家名称
     */
    @TableField(value = "mf_biz_name")
    private String mfBizName;

    /**
     * 广告信息
     */
    @TableField(value = "ad_info")
    private String adInfo ;

    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.UPDATE)
    private Date updateTime;


}
