package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-YearReport")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class YearReport implements Serializable {
    /**
     * 年度报表id
     */
    @ApiModelProperty(value = "年度报表id")
    private String id;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    private String organizationId;

    /**
     * 年初数量
     */
    @ApiModelProperty(value = "年初数量")
    private Integer startNum;

    /**
     * 年末数量
     */
    @ApiModelProperty(value = "年末数量")
    private Integer endNum;

    /**
     * 年初金额
     */
    @ApiModelProperty(value = "年初金额")
    private Integer startMoney;

    /**
     * 年末金额
     */
    @ApiModelProperty(value = "年末金额")
    private Integer endMoney;

    /**
     * 年度销毁数量
     */
    @ApiModelProperty(value = "年度销毁数量")
    private Integer destructionNum;

    private static final long serialVersionUID = 1L;
}