package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value="com-junmp-jyzb-domain-WarehouseArea")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class WarehouseArea implements Serializable {
    /**
    * 区域主键
    */
    @ApiModelProperty(value="区域主键")
    private String areaId;

    /**
    * 区域名称
    */
    @ApiModelProperty(value="区域名称")
    private String areaName;

    /**
    * 所属组织机构
    */
    @ApiModelProperty(value="所属组织机构")
    private Long orgIdInt;

    /**
    * 所属仓库id
    */
    @ApiModelProperty(value="所属仓库id")
    private String warehouseId;

    /**
    * 区域照片
    */
    @ApiModelProperty(value="区域照片")
    private String photo;

    @ApiModelProperty(value="")
    private Date createTime;

    @ApiModelProperty(value="")
    private Date updateTime;

    @ApiModelProperty(value="")
    private String createUser;

    @ApiModelProperty(value="")
    private String updateUser;

    private static final long serialVersionUID = 1L;
}