package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
    * process_templates
    */
@ApiModel(value="com-junmp-jyzb-domain-ProcessTemplates")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProcessTemplates implements Serializable {
    /**
    * 审批摸板ID
    */
    @ApiModelProperty(value="审批摸板ID")
    private String templateId;

    /**
    * 摸板名称
    */
    @ApiModelProperty(value="摸板名称")
    private String templateName;

    /**
    * 基础设置
    */
    @ApiModelProperty(value="基础设置")
    private String settings;

    /**
    * 摸板表单
    */
    @ApiModelProperty(value="摸板表单")
    private String formJson;

    /**
    * process
    */
    @ApiModelProperty(value="process")
    private String processJson;

    /**
    * 图标
    */
    @ApiModelProperty(value="图标")
    private String icon;

    /**
    * 图标背景色
    */
    @ApiModelProperty(value="图标背景色")
    private String background;

    /**
    * notify
    */
    @ApiModelProperty(value="notify")
    private String notify;

    /**
    * 谁能提交
    */
    @ApiModelProperty(value="谁能提交")
    private String whoCommit;

    /**
    * 谁能编辑
    */
    @ApiModelProperty(value="谁能编辑")
    private String whoEdit;

    /**
    * 谁能导出数据
    */
    @ApiModelProperty(value="谁能导出数据")
    private String whoExport;

    /**
    * remark
    */
    @ApiModelProperty(value="remark")
    private String remark;

    /**
    * 冗余分组id
    */
    @ApiModelProperty(value="冗余分组id")
    private Integer groupId;

    /**
    * 是否已停用
    */
    @ApiModelProperty(value="是否已停用")
    private Byte isStop;

    /**
    * 创建时间
    */
    @ApiModelProperty(value="创建时间")
    private Date created;

    /**
    * 更新时间
    */
    @ApiModelProperty(value="更新时间")
    private Date updated;

    private static final long serialVersionUID = 1L;
}