package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-Package")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class Package implements Serializable {
    /**
     * 装备包ID
     */
    @ApiModelProperty(value = "装备包ID")
    private String id;

    /**
     * 包内物资总数
     */
    @ApiModelProperty(value = "包内物资总数")
    private Integer count;

    /**
     * 组织机构ID
     */
    @ApiModelProperty(value = "组织机构ID")
    private String orgId;

    /**
     * 具体位置ID(仓库/单警柜)
     */
    @ApiModelProperty(value = "具体位置ID(仓库/单警柜)")
    private String location;

    /**
     * 货架ID
     */
    @ApiModelProperty(value = "货架ID")
    private String shelfId;

    /**
     * 货架名称
     */
    @ApiModelProperty(value = "货架名称")
    private String shelfName;

    /**
     * 货架编号
     */
    @ApiModelProperty(value = "货架编号")
    private String shelfCode;

    /**
     * 解包状态:0未解包/1已解包
     */
    @ApiModelProperty(value = "解包状态:0未解包/1已解包")
    private Integer state;

    /**
     * 是否销毁:0否/1是
     */
    @ApiModelProperty(value = "是否销毁:0否/1是")
    private Integer isDestroy;

    /**
     * EPC信息
     */
    @ApiModelProperty(value = "EPC信息")
    private String epc;

    /**
     * 标签打印状态:0否/1是
     */
    @ApiModelProperty(value = "标签打印状态:0否/1是")
    private Integer printState;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    private static final long serialVersionUID = 1L;
}