package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-LogSummary")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class LogSummary implements Serializable {
    /**
     * 出入库汇总ID
     */
    @ApiModelProperty(value = "出入库汇总ID")
    private Integer id;

    /**
     * 组织机构ID
     */
    @ApiModelProperty(value = "组织机构ID")
    private String orgId;

    /**
     * 组织机构名称
     */
    @ApiModelProperty(value = "组织机构名称")
    private String orgName;

    /**
     * 仓库ID
     */
    @ApiModelProperty(value = "仓库ID")
    private String warehouseId;

    /**
     * 仓库名称
     */
    @ApiModelProperty(value = "仓库名称")
    private String warehouseName;

    /**
     * 设备标识
     */
    @ApiModelProperty(value = "设备标识")
    private String device;

    /**
     * 出入设备:0手持机/1单警柜/2通道
     */
    @ApiModelProperty(value = "出入设备:0手持机/1单警柜/2通道")
    private Integer deviceType;

    /**
     * 操作时间
     */
    @ApiModelProperty(value = "操作时间")
    private Date useTime;

    /**
     * 操作人员姓名
     */
    @ApiModelProperty(value = "操作人员姓名")
    private String userName;

    /**
     * 出入库类型:0出库/1入库
     */
    @ApiModelProperty(value = "出入库类型:0出库/1入库")
    private Integer outInState;

    /**
     * 照片信息
     */
    @ApiModelProperty(value = "照片信息")
    private String picture;

    private static final long serialVersionUID = 1L;
}