package com.junmp.jyzb.domain;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-EquipmentSize")
@Data
@AllArgsConstructor
@NoArgsConstructor
public class EquipmentSize implements Serializable {
    /**
     * 装备号型ID
     */
    @ApiModelProperty(value = "装备号型ID")
    private String id;

    /**
     * 装备类型ID
     */
    @ApiModelProperty(value = "装备类型ID")
    private String typeId;

    /**
     * 信息关联ID
     */
    @ApiModelProperty(value = "信息关联ID")
    private String detailId;

    /**
     * 号型码
     */
    @ApiModelProperty(value = "号型码")
    private String code;

    /**
     * 号型名称
     */
    @ApiModelProperty(value = "号型名称")
    private String name;

    /**
     * 创建时间
     */
    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    /**
     * 更新时间
     */
    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String note;

    /**
     * 价格
     */
    @ApiModelProperty(value = "价格")
    private Double price;

    /**
     * 当前状态：0关闭/1启用
     */
    @ApiModelProperty(value = "当前状态：0关闭/1启用")
    private Integer state;

    /**
     * EPC类型
     */
    @ApiModelProperty(value = "EPC类型")
    private Integer epcType;

    private static final long serialVersionUID = 1L;
}