package com.junmp.jyzb.controller;

import com.junmp.jyzb.service.PoliceFingerService;
import com.junmp.jyzb.service.PolicemanService;
import com.junmp.jyzb.service.WarehouseService;
import com.junmp.jyzb.utils.HttpStatus;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.jyzb.utils.ReturnData;
import com.junmp.jyzb.utils.ReturnMsg;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/Warehouse")
@Api(tags = "仓库基础信息模块")
public class WarehouseController {
    @Resource
    public WarehouseService warehouseService;

    @PostMapping("/AddWarehouse")
    @ApiOperation("添加仓库")
    public ResponseResult addWarehouse(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.addWarehouse(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteWarehouse")
    @ApiOperation("删除仓库信息")
    public ResponseResult deleteWarehouse(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.deleteWarehouse(msg);
        return returnMsg;
    }

    @PostMapping("/ChangeWarehouseState")
    @ApiOperation("禁用/启用仓库")
    public ResponseResult changeWarehouseState(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.changeWarehouseState(msg);
        return returnMsg;
    }

    @PostMapping("/ShowWarehouse")
    @ApiOperation("查询仓库列表")
    public ResponseResult getAllWarehouse(@RequestBody Map<String, Object> orgId){
        ResponseResult returnMsg = warehouseService.getAllWarehouse(orgId);
        return  returnMsg;

//        //获取该组织机构下所有警员的id
//        List<Map<String, Object>> allWarehouse=new ArrayList<>();
//        List<String> allWarehouseId =warehouseService.getAllWarehouseId(orgId);
//        for (String warehouseId :allWarehouseId){
//            Map<String, Object> warehouseMsg = warehouseService.getOneWarehouse(warehouseId);
//            allWarehouse.add(warehouseMsg);
//        }
//        return new ResponseResult(HttpStatus.SUCCESS,ReturnMsg.PASS,allWarehouse);
    }

    @PostMapping("/GetWarehouseDetail")
    @ApiOperation("查询单个仓库信息")
    public ResponseResult getOneWarehouse(@RequestBody Map<String, Object> msg) {
        ResponseResult returnMsg = warehouseService.getOneWarehouse(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateWarehouse")
    @ApiOperation("修改仓库信息")
    public ResponseResult updateWarehouse(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.updateWarehouse(msg);
        return returnMsg;
    }


    @PostMapping("/AddArea")
    @ApiOperation("添加区域")
    public ResponseResult addArea(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.addArea(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateArea")
    @ApiOperation("修改区域")
    public ResponseResult updateArea(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.updateArea(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteArea")
    @ApiOperation("删除区域")
    public ResponseResult deleteArea(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.deleteArea(msg);
        return returnMsg;
    }

    @PostMapping("/GetAreaList")
    @ApiOperation("查询区域信息")
    public ResponseResult getAreaList(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = warehouseService.getAreaList(msg);
        return  returnMsg;
    }

    @PostMapping("/AddShelf")
    @ApiOperation("添加货架")
    public ResponseResult addShelf(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.addShelf(msg);
        return returnMsg;
    }

    @PostMapping("/UpdateShelf")
    @ApiOperation("修改货架")
    public ResponseResult updateShelf(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.updateShelf(msg);
        return returnMsg;
    }

    @PostMapping("/DeleteShelf")
    @ApiOperation("删除货架")
    public ResponseResult deleteShelf(@RequestBody Map<String,Object> msg) {
        ResponseResult returnMsg = warehouseService.deleteShelf(msg);
        return returnMsg;
    }

    @PostMapping("/GetShelfList")
    @ApiOperation("查询区域信息")
    public ResponseResult getShelfList(@RequestBody Map<String, Object> msg){
        ResponseResult returnMsg = warehouseService.getShelfList(msg);
        return  returnMsg;
    }
}
