package com.junmp.junmpProcess.service;

import com.junmp.junmpProcess.common.utils.ResponseResult;
import com.junmp.junmpProcess.dto.ApplyDTO;
import com.junmp.junmpProcess.dto.HandleDataDTO;
import com.junmp.junmpProcess.dto.TaskDTO;
import com.junmp.junmpProcess.vo.HistoryProcessInstanceVO;
import com.junmp.junmpProcess.vo.RecordVO;
import com.junmp.junmpProcess.vo.TaskDetailVO;
import com.junmp.junmpProcess.vo.TaskVO;
import com.junmp.v2.common.bean.response.ApiRes;
import com.junmp.v2.db.api.page.PageResult;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

public interface IFlowTaskService {

    /**
     * 同意
     *
     * @return
     */
    ResponseResult agree(HandleDataDTO handleDataDTO);

    /**
     * 拒绝
     *
     * @return
     */
    ResponseResult refuse(HandleDataDTO handleDataDTO);

    /**
     * 撤销
     *
     * @return
     */
    ResponseResult revoke(HandleDataDTO handleDataDTO);

    /**
     * 查看我的待办
     *
     * @return
     */
    PageResult<TaskVO> toDoList(TaskDTO taskDTO);

    /**
     * 查看我的已办
     *
     * @return
     */
    PageResult<TaskVO> doneList(@RequestBody TaskDTO taskDTO);

    /**
     * 查看我发起的流程
     *
     * @return
     */
    PageResult<HistoryProcessInstanceVO> applyList(ApplyDTO applyDTO);

    /**
     * 查询流程历史记录
     *
     * @return
     */
    ApiRes<RecordVO> record(String processInstanceId,String userID);
}
