package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.QueryTriggerReq;
import com.junmp.jyzb.api.bean.req.UpdateTriggerReq;
import com.junmp.jyzb.api.exception.enums.TriggerExceptionEnum;
import com.junmp.jyzb.entity.Trigger;
import com.junmp.jyzb.mapper.TriggerMapper;
import com.junmp.jyzb.service.TriggerService;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.UUID;
@Service
public class TriggerServiceImpl extends ServiceImpl<TriggerMapper, Trigger> implements TriggerService {
    @Override
    public String addTrigger(UpdateTriggerReq req) {
        Trigger trigger = new Trigger();
        String ID= UUID.randomUUID().toString();
        req.setId(ID);
        BeanPlusUtil.copyProperties(req, trigger);
        this.save(trigger);
        return ID;
    }

    @Override
    public Boolean updateTrigger(UpdateTriggerReq req) {
        Trigger trigger = this.Query(req);
        BeanPlusUtil.copyProperties(req, trigger);
        return this.updateById(trigger);
    }
    private Trigger Query(UpdateTriggerReq req) {
        Trigger app = this.getById(req.getId());
        if (ObjectUtil.isNull(app)) {
            throw new ServiceException(TriggerExceptionEnum.TRIGGER_NOT_EXIST);
        }
        return app;
    }
    @Override
    public Boolean deleteTrigger(UpdateTriggerReq req) {

        TriggerExist(req.getId());
        Trigger trigger = new Trigger();
        BeanPlusUtil.copyProperties(req,trigger);
        return this.removeById(trigger.getId());
    }
    private Trigger TriggerExist(String id){
        Trigger trigger = this.getById(id);
        if (ObjectUtil.isNull(trigger)){
            throw new ServiceException(TriggerExceptionEnum.TRIGGER_NOT_EXIST);
        }
        return trigger;
    }
    @Override
    public boolean changeTriggerState(UpdateTriggerReq req) {
        Trigger trigger = this.Query(req);
        BeanPlusUtil.copyProperties(req, trigger);
        return this.updateById(trigger);
    }

    public List<Trigger> getTriggerList(QueryTriggerReq req)
    {
        LambdaQueryWrapper<Trigger> wrapper = createWrapper(req);
        return this.list(wrapper);
//        Page<Trigger> page = this.page(PageFactory.getDefaultPage(req.getPageNo(),req.getPageSize()), wrapper);
//        return PageResultFactory.createPageResult(page);
    }
    private LambdaQueryWrapper<Trigger> createWrapper(QueryTriggerReq req) {
        LambdaQueryWrapper<Trigger> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据业务编码查询
        wrapper.like(ObjectUtil.isNotEmpty(req.getTriggerName()), Trigger::getTriggerName, req.getTriggerName());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getId()), Trigger::getId, req.getId());
        wrapper.eq(ObjectUtil.isNotEmpty(req.getDelFlag()), Trigger::getDelFlag, req.getDelFlag());

        wrapper.orderByDesc(Trigger::getUpdateTime);
        wrapper.orderByDesc(Trigger::getCreateTime);
        return wrapper;
    }

}
