package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.query.SupplierTypeReq;
import com.junmp.jyzb.entity.SupplierType;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.SupplierTypeMapper;
import com.junmp.jyzb.service.SupplierTypeService;

@Service
public class SupplierTypeServiceImpl extends ServiceImpl<SupplierTypeMapper, SupplierType> implements SupplierTypeService{

    private LambdaQueryWrapper<SupplierType> createWrapper(SupplierTypeReq req) {
        LambdaQueryWrapper<SupplierType> wrapper = new LambdaQueryWrapper<>();
        if (ObjectUtil.isEmpty(req)) {
            return wrapper;
        }
        //根据供应商短码查询查询
        wrapper.in(ObjectUtil.isNotEmpty(req.getSupplierId()), SupplierType::getSupplierId, req.getSupplierId());
        //供应商ID模糊查询
        wrapper.in(ObjectUtil.isNotEmpty(req.getTypeId()), SupplierType::getTypeId, req.getTypeId());
        //根据创建时间降序
        wrapper.orderByDesc(SupplierType::getCreateTime);
        return wrapper;
    }
}
