package com.junmp.jyzb.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.junmp.jyzb.api.bean.dto.*;
import com.junmp.jyzb.api.bean.query.ShelfReq;
import com.junmp.jyzb.api.bean.req.UpdateShelfReq;
import com.junmp.jyzb.api.exception.enums.ShelfExceptionEnum;
import com.junmp.jyzb.api.exception.enums.WarehouseAreaExceptionEnum;
import com.junmp.jyzb.api.exception.enums.WarehouseExceptionEnum;
import com.junmp.jyzb.entity.*;
import com.junmp.jyzb.service.*;
import com.junmp.jyzb.utils.DateTimeUtil;
import com.junmp.v2.common.exception.base.ServiceException;
import com.junmp.v2.common.util.BeanPlusUtil;
import org.springframework.stereotype.Service;
import javax.annotation.Resource;
import com.junmp.jyzb.mapper.ShelfMapper;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Service
public class ShelfServiceImpl extends ServiceImpl<ShelfMapper, Shelf> implements ShelfService {

    @Resource
    private WarehouseService warehouseService;
    @Resource
    private WarehouseAreaService warehouseAreaService;

    @Override
    public String AddShelf(UpdateShelfReq req) {
        //判断仓库是否存在
        warehouseService.WarehoustExist(req.getWarehouseId());
        //判断区域是否存在
//        warehouseAreaService.WarehouseAreaExist(req.getAreaId());
        //判断区域id是否在该仓库中，如果不是则抛出异常
        List<WarehouseArea> list = warehouseAreaService.list(new LambdaQueryWrapper<WarehouseArea>()
                .eq(WarehouseArea::getWarehouseId, req.getWarehouseId())
                .eq(ObjectUtil.isNotNull(req.getAreaId()), WarehouseArea::getAreaId, req.getAreaId()));
        if (list.size()<=0){
            throw new ServiceException(WarehouseAreaExceptionEnum.AREA_ERROR);
        }
        Shelf shelf = new Shelf();
        BeanPlusUtil.copyProperties(req,shelf);
        shelf.setCreateTime(DateTimeUtil.getCurrentDateTime());
        shelf.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        save(shelf);
        return shelf.getShelfId();
    }

    @Override
    public boolean UpdateShelf(UpdateShelfReq req) {
        //判断货架id是否正确
        Shelf shelf = ShelfExist(req.getShelfId());
        BeanPlusUtil.copyProperties(req, shelf);
        shelf.setUpdateTime(DateTimeUtil.getCurrentDateTime());
        return this.updateById(shelf);
    }

    @Override
    public boolean DeleteShelf(UpdateShelfReq req) {
        ShelfExist(req.getShelfId());
        return removeById(req.getShelfId());
    }

    @Override
    public List<ShelfDto> GetShelfList(ShelfReq req) {
        //判断仓库id是否存在
        warehouseService.WarehoustExist(req.getWarehouseId());
        List<Shelf> list = list(new LambdaQueryWrapper<Shelf>()
                .eq(Shelf::getWarehouseId,req.getWarehouseId()));
        List<ShelfDto> shelfDtoList=new ArrayList<>();
        for (Shelf shelf:list) {
            ShelfDto shelfDto = new ShelfDto();
            BeanPlusUtil.copyProperties(shelf,shelfDto);
            shelfDtoList.add(shelfDto);
        }
        return shelfDtoList;
    }


    /**
     * 判断货架id是否存在
     * @param 
     * @return
     */
    public Shelf ShelfExist(String id) {
        Shelf shelf = this.getById(id);
        if (ObjectUtil.isNull(shelf)) {
            throw new ServiceException(ShelfExceptionEnum.SHELF_NOT_EXIST);
        }
        return shelf;
    }

}
