package com.junmp.jyzb.service;

import com.junmp.jyzb.api.bean.dto.LogDetailDto;
import com.junmp.jyzb.api.bean.query.InventoryReq;
import com.junmp.jyzb.api.bean.query.LogDetailReq;
import com.junmp.jyzb.api.bean.query.LogSummaryReq;
import com.junmp.jyzb.entity.LogDetail;
import com.baomidou.mybatisplus.extension.service.IService;
import com.junmp.v2.db.api.page.PageResult;

import java.util.List;

/**
* @author lxh专属坐骑
* @description 针对表【base_log_detail】的数据库操作Service
* @createDate 2023-10-13 08:29:42
*/
public interface LogDetailService extends IService<LogDetail> {

    //根据logSumId查询详情
    List<LogDetailDto> GetDetailByLogSumId(LogDetailReq req);

    //根据单据获取出入库记录
    List<LogDetailDto> ShowInOutRecordsByOrder(LogSummaryReq req);

    //获取装备的出入库记录(根据装备id获取某件装备的出入库记录信息)
    PageResult<LogDetail> getInOutRecords(InventoryReq req);
}
