package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.junmp.v2.common.bean.request.ValidationApi;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;

@Data
@TableName("base_supplier")
public class Supplier implements Serializable {
    /**
     * 供应商ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 供应商名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 供应商短码
     */
    @TableField(value = "code")
    private String code;

    /**
     * 简称
     */
    @TableField(value = "short_name")
    private String shortName;

    /**
     * 类型，（0为供应商，1为生产厂商，2为维修单位，3为销毁单位）
     */
    @TableField(value = "agency_type")
    private Integer agencyType;

    /**
     * 联系人
     */
    @TableField(value = "contacts")
    private String contacts;

    /**
     * 联系电话
     */
    @TableField(value = "phone")
    private String phone;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "create_time")
    private Date createTime;

    @TableField(fill = FieldFill.INSERT_UPDATE, value = "update_time")
    private Date updateTime;


    /**
     * 更新人ID
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新人ID
     */
    @TableField(value = "update_user")
    private String updateUser;

    /**
     * 1为启用，0为禁用
     */
    @TableField(value = "state")
    private Integer state;

    private static final long serialVersionUID = 1L;
}