package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 维修单位表
 * @TableName base_repair_unit
 */
@TableName(value ="base_repair_unit")
@Data
public class RepairUnit implements Serializable {
    /**
     * 维修单位id
     */
    private String id;

    /**
     * 维修单位名称
     */
    @TableField(value = "name")
    private String name;

    /**
     * 维修单位短码
     */
    @TableField(value = "code")
    private String code;

    /**
     * 简称
     */
    @TableField(value = "short_name")
    private String shortName;

    /**
     * 联系人
     */
    @TableField(value = "contacts")
    private String contacts;

    /**
     * 联系电话
     */
    @TableField(value = "phone")
    private String phone;

    /**
     * 状态（1为启用，0为禁用）
     */
    @TableField(value = "state")
    private Integer state;

    /**
     * 创建时间
     */
    @TableField(value = "create_time")
    private Date createTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新时间
     */
    @TableField(value = "update_time")
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;


}