package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_manufacturer
 * 生产厂商
 */
@TableName(value ="base_manufacturer")
@Data
public class Manufacturer implements Serializable {
    /**
     * 生产厂商id
     */
    @TableId(value = "id",type = IdType.ASSIGN_UUID)
    private String id;

    /**
     * 厂商名称
     */
    private String name;

    /**
     * 厂商短码
     */
    private String code;

    /**
     * 简称
     */
    @TableField(value = "short_name")
    private String shortName;

    /**
     * 联系人
     */
    private String contacts;

    /**
     * 联系电话
     */
    private String phone;

    /**
     * 状态（1为启用，0为禁用）
     */
    private String state;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 创建人员
     */
    @TableField(value = "create_user")
    private String createUser;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 更新人员
     */
    @TableField(value = "update_user")
    private String updateUser;


    private static final long serialVersionUID = 1L;


}