package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@ApiModel(value = "com-junmp-jyzb-domain-History")
@Data
@AllArgsConstructor
@NoArgsConstructor
@TableName("base_history")
public class History implements Serializable {
    /**
     * 历史记录id
     */
    @ApiModelProperty(value = "历史记录id")
    private String id;

    /**
     * 装备类型id
     */
    @ApiModelProperty(value = "装备类型id")
    @TableField("equipmen_id")
    private String equipmentId;

    /**
     * 组织机构id
     */
    @ApiModelProperty(value = "组织机构id")
    @TableField("organization_id")
    private String organizationId;

    /**
     * 要查询的时间
     */
    @ApiModelProperty(value = "要查询的时间")
    @TableField("search_date")
    private Date searchDate;

    /**
     * 当月使用次数
     */
    @ApiModelProperty(value = "当月使用次数")
    @TableField("use_month")
    private Integer useMonth;

    /**
     * 当月维修次数
     */
    @ApiModelProperty(value = "当月维修次数")
    @TableField("fix_month")
    private Integer fixMonth;

    private static final long serialVersionUID = 1L;
}