package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Data;

/**
 * 
 * @TableName base_order_items
 */
@TableName(value ="bussiness_handover_bill")
@Data
public class HandoverBill implements Serializable {
    /**
     * 子单据id
     */
    private Long id;

    /**
     * 主单据id
     */
    @TableField("order_id")
    private String orderId;

    /**
     * 装备号型id
     */
    @TableField("size_id")
    private String sizeId;

    /**
     * 号型名称
     */
    @TableField("size_name")
    private String sizeName;

    /**
     * 类型id
     */
    @TableField("type_id")
    private String typeId;

    /**
     * 类型名称
     */
    @TableField("type_name")
    private String typeName;

    /**
     * 供应商id
     */
    @TableField("supplier_id")
    private String supplierId;

    /**
     * 供应商名称
     */
    @TableField("supplier_name")
    private String supplierName;

    /**
     * 价格
     */
    private BigDecimal price;

    /**
     * 数量
     */
    private Integer num;

    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;

    /**
     * 创建人员
     */
    @TableField("create_user")
    private String createUser;

    /**
     * 更新人员
     */
    @TableField("update_user")
    private String updateUser;

    private static final long serialVersionUID = 1L;


}