package com.junmp.jyzb.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.Document;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 *
 * @TableName base_bus_form
 */
@TableName(value ="bussiness_inventory")
@Data
@AllArgsConstructor
@NoArgsConstructor
@JsonIgnoreProperties(ignoreUnknown = true)
public class BussinessInventory implements Serializable {
    /**
     * id
     */
    @TableId(value = "id")
    @Id
    private String id;

    /**
     * 工作流id
     */
    @TableField(value = "process_id")
    private String processId;
    /**
     * 工作流id
     */
    @TableField(value = "current_assign")
    private String currentAssign;
    /**
     * 工作流id
     */
    @TableField(value = "history_assign")
    private String historyAssign;
    /**
     * 单据编号
     */
    @TableField(value = "order_num")
    private String orderNum;

    /**
     * 年度
     */
    @TableField(value = "year")
    private Integer year;

    /**
     * 月
     */
    @TableField(value = "month")
    private Integer month;

    /**
     * 申请时间
     */
    @TableField(value = "apply_time")
    private Date applyTime;

    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_id")
    private String warehouseId;
    /**
     * 仓库名称
     */
    @TableField(value = "warehouse_name")
    private String warehouseName;
    /**
     * 组织机构ID
     */
    @TableField(value = "org_id")
    private Long orgId;

    /**
     * 组织机构名称
     */
    @TableField(value = "org_name")
    private String orgName;

    /**
     * 经办人
     */
    @TableField(value = "operator")
    private String operator;

    /**
     * 盘点状态
     */
    @TableField(value = "inventory_state")
    private String inventoryState;

    /**
     *
     */
    @TableField(value = "inventory_type")
    private Integer inventoryType;

    /**
     *
     */
    @TableField(value = "total_num")
    private Integer totalNum;
    /**
     *
     */
    @TableField(value = "actual_num")
    private Integer actualNum;
    /**
     *
     */
    @TableField(value = "add_num")
    private Integer addNum;

    /**
     *
     */
    @TableField(value = "delete_num")
    private Integer deleteNum;
    /**
     * 类别
     */
    @TableField(value = "rules")
    private String rules;
    /**
     * 类别
     */
    @TableField(value = "rules_json")
    private String rulesJson;

    /**
     * 经办人id
     */
    @TableField(value = "result")
    private String result;

    /**
     * 原有epc备份
     */
    @TableField(value = "epc_back")
    private String epcBack;

    /**
     * 需要更新的epc汇总
     */
    @TableField(value = "epc_update")
    private String epc_update;

    /**
     * 归还人
     */
    @TableField(value = "examine_state")
    private String examineState;




    /**
     * 创建时间
     */
    @TableField(value = "create_time",fill = FieldFill.INSERT)
    private Date createTime;

    /**
     * 更新时间
     */
    @TableField(value = "update_time",fill = FieldFill.UPDATE)
    private Date updateTime;
    @TableField(value = "detail_list", exist = false)
    private List<BussinessDetail> detailList;

    @TableField(value = "api", exist = false)
    private String api;

    private static final long serialVersionUID = 1L;

}