package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.ESOrgDto;
import com.junmp.jyzb.api.bean.dto.OrgDto;
import com.junmp.jyzb.api.bean.query.QueryOrgReq;
import com.junmp.jyzb.api.bean.req.UpdateOrgReq;
import com.junmp.jyzb.entity.PubOrg;
import com.junmp.jyzb.service.PubOrgService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

@RestController
@Slf4j
@RequestMapping("/PubOrg")
@Api(tags = "[基础信息]组织机构模块")
public class PubOrgController {
    @Resource
    public PubOrgService pubOrgService;

    @GetMapping(path="/SetOrgParentIds",name="填充组织机构的parent_ids字段#logType=30")
    @ApiOperation("填充组织机构的parent_ids字段")
    public ResponseResult setOrgParentIds() {
        //传入当前的组织机构id，展示所有本级及下级的
        ResponseResult returnMsg = pubOrgService.setOrgParentIds();
        return returnMsg;
    }

    @PostMapping(path="/setShortName",name="填充组织机构简称到数据库#logType=30")
    @ApiOperation("填充组织机构简称到数据库")
    public ResponseResult setShortName(@RequestBody Map<String, Object> orgId) {
        ResponseResult returnMsg = pubOrgService.setShortName(orgId);
        return returnMsg;
    }
    @PostMapping(path="/GetOrgList",name="查询组织机构列表#enable")
    @ApiOperation("查询组织机构列表")
    public ApiRes<List<OrgDto>> getOrgList(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getOrgList(req));
    }
    @PostMapping(path="/GetCurrentList",name="根据当前组织机构列表查询#enable")
    @ApiOperation("根据当前组织机构列表查询")
    public ApiRes<OrgDto> GetCurrentList(@RequestBody @Validated(ValidationApi.detail.class) QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getOrgHierarchy(req));
    }

    @PostMapping(path="/GetCurrentESList",name="根据当前组织机构列表ES查询#enable")
    @ApiOperation("根据当前组织机构列表ES查询")
    public ApiRes<ESOrgDto> GetCurrentESList(@RequestBody  QueryOrgReq req) throws IOException {
        return ApiRes.success(pubOrgService.getOrgTreeByEs(req));
    }
    @PostMapping(path="/ChangeOrgState",name="改变组织机构状态信息#logType=30")
    @ApiOperation("改变组织机构状态信息")
    public ApiRes<Boolean> changeOrgState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateOrgReq req) {
        return ApiRes.success(pubOrgService.ChangeState(req));
    }

    @PostMapping(path="/GetLowOrg",name="根据组织机构查询下一级信息#enable")
    @ApiOperation("根据组织机构查询下一级信息")
    public ApiRes<List<OrgDto>> getLowOrg(@RequestBody QueryOrgReq req) {
        return ApiRes.success(pubOrgService.getLowOrg(req)) ;
    }
    //通过组织机构id获取上一层的组织机构数据
    @PostMapping(path="/getUpOrgInfo",name="获取上级组织机构信息#enable")
    @ApiOperation("获取上级组织机构信息")
    public ApiRes<OrgDto> getUpOrgInfo(@RequestBody QueryOrgReq req){
        return ApiRes.success(pubOrgService.getUpOrgInfo(req));
    }

    //新增

    @ApiOperation("新增组织机构信息")
    @PostMapping(path="/addPubOrg",name="新增组织机构信息#logType=30")
    public ApiRes<Long> addPubOrg(@RequestBody @Validated(ValidationApi.add.class) UpdateOrgReq req){
        return ApiRes.success(pubOrgService.addPubOrg(req));
    }
    //修改（名字，状态）
    @ApiOperation("修改组织机构信息")
    @PostMapping(path="/updatePubOrg",name="修改组织机构信息#logType=30")
    public ApiRes<Boolean> updatePubOrg(@RequestBody @Validated(ValidationApi.edit.class) UpdateOrgReq req){
        return ApiRes.success(pubOrgService.updatePubOrg(req));
    }

    //获取组织机构信息（区域编码）也可以复用获取单个组织机构的所有信息
    @PostMapping(path = "/getOneOrgInfo",name = "获取组织机构区域编码#enable")
    @ApiOperation("获取组织机构区域编码")
    public ApiRes<PubOrg> getOneOrgInfo(@RequestBody @Validated(ValidationApi.detail.class)UpdateOrgReq req){
        return ApiRes.success(pubOrgService.getOneOrgInfo(req));
    }

}
