package com.junmp.jyzb.controller;

import com.junmp.jyzb.api.bean.dto.ESTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTypeDto;
import com.junmp.jyzb.api.bean.dto.EquipmentTreeDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.SizeDto;
import com.junmp.jyzb.api.bean.dto.FetchingDataDto.TypeDto;
import com.junmp.jyzb.api.bean.query.QueryEquipmentTypeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentSizeReq;
import com.junmp.jyzb.api.bean.req.UpdateEquipmentTypeReq;
import com.junmp.jyzb.service.EquipmentTypeService;
import com.junmp.jyzb.utils.ResponseResult;
import com.junmp.v2.common.bean.request.ValidationApi;
import com.junmp.v2.common.bean.response.ApiRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;

@RestController
@Slf4j
@RequestMapping("/Equipment")
@Api(tags = "[基础信息]物资基础信息模块")
public class EquipmentTypeController {
    @Resource
    public EquipmentTypeService equipmentTypeService;


    @PostMapping(path="/AddEquipment",name="添加物资#logType=30")
    @ApiOperation("添加物资")
    public ApiRes<String> addEquipment(@RequestBody @Validated(ValidationApi.add.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.addEquipment(req));
    }



    @PostMapping(path="/DeleteEquipment",name="删除装备信息#logType=30")
    @ApiOperation("删除装备信息")
    public ApiRes<Boolean> deleteEquipment(@RequestBody @Validated(ValidationApi.delete.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.deleteEquipment(req));
    }


    @PostMapping(path="/ChangeEquipmentState",name="禁用启用装备类型#logType=30")
    @ApiOperation("禁用/启用装备类型")
    public ApiRes<Boolean> changeEquipmentState(@RequestBody @Validated(ValidationApi.updateStatus.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.changeEquipmentState(req));
    }

    @PostMapping(path="/ShowEquipmentList",name="查询类别列表#enable")
    @ApiOperation("查询类别列表")
    public ApiRes<List<EquipmentTypeDto>> ShowEquipmentList(@RequestBody QueryEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.getEquipmentList(req));
    }

    @PostMapping(path="/ShowEquipmentESList",name="查看业务单#enable")
//@PostMapping(path="/ShowEquipmentESList",name="通过ES模糊检索类别列表#logType=30")
    @ApiOperation("通过ES模糊检索类别列表")
    public ApiRes<ESTypeDto> ShowEquipmentESList(@RequestBody QueryEquipmentTypeReq req) throws IOException {
        return ApiRes.success(equipmentTypeService.getTypeTreeByEs(req));
    }


    @PostMapping(path="/GetEquipmentDetail",name="查询单个物资信息#enable")
    @ApiOperation("查询单个物资信息")
    public ApiRes<EquipmentTypeDto> getEquipment(@RequestBody QueryEquipmentTypeReq req) {
        return ApiRes.success( equipmentTypeService.getEquipment(req));
    }
    @PostMapping(path="/getLowType",name="根据上级物资查询下一级信息#enable")
    @ApiOperation("根据上级物资查询下一级信息")
    public ApiRes<List<EquipmentTypeDto>> getLowType(@RequestBody QueryEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.getLowType(req)) ;

    }

    @PostMapping(path="/UpdateEquipment",name="修改物资信息#logType=30")
    @ApiOperation("修改物资信息")
    public ApiRes<Boolean> updateEquipment(@RequestBody @Validated(ValidationApi.edit.class) UpdateEquipmentTypeReq req) {
        return ApiRes.success(equipmentTypeService.updateEquipment(req));
    }



//    @PostMapping(path="/SetTypeParentIds",name="填充装备类型的parent_ids字段#logType=30")
//    @ApiOperation("填充装备类型的parent_ids字段")
//    public ResponseResult setTypeParentIds() {
//        ResponseResult returnMsg = equipmentTypeService.setTypeParentIds();
//        return returnMsg;
//    }

    //返回整棵物资树

    @PostMapping(path="/GetTypeTree",name="获取整棵物资树#enable")
    @ApiOperation("/获取整棵物资树")
    public ApiRes<List<EquipmentTreeDto>> GetTypeTree(@RequestBody QueryEquipmentTypeReq req){
        return ApiRes.success(equipmentTypeService.GetTypeTree(req));
    }




    @PostMapping(path="/alignTypeInfo",name="同步更新类型信息#enable")
    @ApiOperation("同步更新类型信息")
    public ApiRes<List<TypeDto>> alignTypeInfo(@RequestBody @Validated(ValidationApi.export.class) UpdateEquipmentTypeReq req){
        return ApiRes.success(equipmentTypeService.alignTypeInfo(req));
    }

    @PostMapping(path = "/exportSizeAndType",name = "导出指定时间后的类型号型组织机构#enable")
    @ApiOperation("导出指定时间后的类型号型组织机构")
    public ApiRes<String> exportSizeAndType(@RequestBody QueryEquipmentTypeReq req){
        return ApiRes.success(equipmentTypeService.exportSizeAndType(req));
    }



}
